/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.StockBlankChangeLocationProperties;
import com.gridnine.xtrip.common.fx.rpc.StockBlankChangeStatusProperties;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;

public final class StockControlHelper {
    public static void changeStockBlankLocation(final List<EntityReference<StockBlank>> references, Node view) {
        final EntityBoxWidget locationWidget = new EntityBoxWidget(BaseEntity.class, false);
        locationWidget.setListParametersSupplier(new MultiSupplier<IndexListParameters<BaseEntity, ?>>(){
            private final IndexListParameters<?, ?>[] listParameters = new IndexListParameters[]{ControllerInterceptorsHelper.getActiveAgencies(), ControllerInterceptorsHelper.getActiveSalesPoints(), ControllerInterceptorsHelper.getActiveAgents(), ControllerInterceptorsHelper.getCashRegisterWorkplaces()};

            public String getDisplayName(int idx) {
                return MetaRegistryHelper.getDisplayName((Class)this.listParameters[idx].getIndexType());
            }

            public IndexListParameters<BaseEntity, ?> get(int idx) {
                return this.listParameters[idx];
            }

            public int count() {
                return this.listParameters.length;
            }
        });
        new Dialog().setTitle(Messages.Changing_from_location).setMessage(Messages.Select_new_location).setBody((Node)locationWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Change, () -> {
            if (locationWidget.valueProperty().get() != null) {
                Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                    protected String getTitle() {
                        return Messages.Changing_form_location;
                    }

                    protected void onCompleted(Object result, List<Message> log) {
                        EventBus.get().publishAsync((Event)new EntityModificationEvent(null, (Collection)references.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                    }

                    protected Serializable getTaskParameters() {
                        return new StockBlankChangeLocationProperties(references, (EntityReference)locationWidget.valueProperty().get());
                    }

                    protected String getTaskClassName() {
                        return "com.gridnine.xtrip.server.fx.async.entityactions.StockBlankChangeLocationAsyncTask";
                    }
                });
            } else {
                Dialog.info((Node)view, (String)Messages.Must_specify_a_new_location);
            }
        }).show(view);
    }

    public static void changeStockBlankStatus(final List<EntityReference<StockBlank>> references, Node view) {
        final DateValueWidget dateWidget = new DateValueWidget(false);
        dateWidget.valueProperty().set((Object)LocalDate.now());
        final ComboBoxWidget statusWidget = new ComboBoxWidget(false);
        statusWidget.setItemsSupplier(Suppliers.createEnumSupplier(UsageStatus.class));
        final TextFieldWidget validatorWidget = new TextFieldWidget(false);
        GridContainer gridContainer = new GridContainer();
        gridContainer.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Date_of_operation_dv, (Node)dateWidget), new GridCell(Messages.Status_dv, (Node)statusWidget), new GridCell(Messages.Validator_dv, (Node)validatorWidget)});
        new Dialog().setTitle(Messages.Changing_form_status).setBody((Node)gridContainer).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Change, () -> {
            if (statusWidget.valueProperty().get() != null && !TextUtil.isBlank((String)validatorWidget.getValue())) {
                Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                    protected String getTitle() {
                        return Messages.Changing_forms_status;
                    }

                    protected String getTaskClassName() {
                        return "com.gridnine.xtrip.server.fx.async.entityactions.StockBlankChangeStatusAsyncTask";
                    }

                    protected Serializable getTaskParameters() {
                        return new StockBlankChangeStatusProperties(references, DateUtils.asDate((LocalDate)((LocalDate)dateWidget.valueProperty().get())), (UsageStatus)statusWidget.valueProperty().get(), validatorWidget.getValue());
                    }

                    protected void onCompleted(Object result, List<Message> log) {
                        EventBus.get().publishAsync((Event)new EntityModificationEvent(null, (Collection)references.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                    }
                });
            } else {
                Dialog.info((Node)view, (String)Messages.Must_specify_status_and_validator);
            }
        }).show(view);
    }

    private StockControlHelper() {
    }
}

