/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.system;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationMainPane;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationPane;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationSpaceController;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationSpaceVM;
import com.gridnine.xtrip.client.fx.model.system.SysLogDataItemVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.DateShift;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.RecipientsAction;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Region;

class EventNotificationSpaceControllerInterceptor
extends ControllerInterceptor<EventNotificationSpaceVM, EventNotificationSpaceController> {
    EventNotificationSpaceControllerInterceptor() {
    }

    protected Class<EventNotificationSpaceController> getControllerClass() {
        return EventNotificationSpaceController.class;
    }

    protected void onCreate(EventNotificationSpaceController controller) {
        EventNotificationPane notificationPane = (EventNotificationPane)controller.getView().getMainTile().getFullNode();
        EventNotificationMainPane mainPane = (EventNotificationMainPane)notificationPane.getMainCard().getContent();
        ((TableWidget)notificationPane.getRecipientsCard().getContent()).setControlButtonsAvailability(bt -> bt == ControlsPane.ButtonType.REMOVE);
        notificationPane.getRecipientsCard().getActions().addAll((Object[])RecipientsAction.values());
        ((TableWidget)notificationPane.getRecipientsCard().getContent()).getViewState().stateProperty().addListener((s, o, n) -> notificationPane.getRecipientsCard().revalidateActions());
        ((BooleanValueWidget)((EventNotificationMainPane)notificationPane.getMainCard().getContent()).getRepeatOnceYearCell().getPayload()).setConverter(Converters.boolConverter((String)Messages.Notification_repeatOnceYear_annually, (String)Messages.Notification_repeatOnceYear_no));
        mainPane.getAlarmDateNode().setActionHandler((IconShape)StandardIconShapes.ALARM, Messages.Notification_set_alarm_date, node -> {
            LocalDateTime eventDate = mainPane.getEventDateNode().getValue();
            if (eventDate == null) {
                UiUtil.blink((Node)mainPane.getEventDateNode());
                return;
            }
            UiUtil.showListPopup(Arrays.asList(DateShift.values()), Object::toString, shift -> mainPane.getAlarmDateNode().setValue(shift.doShift(eventDate)), (Region)node);
        });
        DataViewWidgetHelper.configureSysLogDataView((DataViewWidget<SysLogDataItemVM>)((DataViewWidget)controller.getView().getSysLogTile().getFullNode()), () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer().toReference();
        }, (ObservableValue<Boolean>)controller.getView().getSysLogTile().expandedProperty());
    }

    protected void afterReadData(EventNotificationSpaceController controller, EventNotificationSpaceVM model) {
        EventNotificationMainPane pane = (EventNotificationMainPane)((EventNotificationPane)controller.getView().getMainTile().getFullNode()).getMainCard().getContent();
        EntityReference ref = model.getMainFull().getMain().getEntityReference();
        if (ref == null) {
            pane.getEntityReferenceActionCell().setHidden(true);
        } else {
            pane.getEntityReferenceActionCell().setHidden(false);
            pane.getEntityReferenceActionNode().setText(ref.toString());
            pane.getEntityReferenceActionNode().setOnAction(evt -> EntityEditorHelper.navigate((EntityReference)ref, (boolean)false));
        }
    }

    protected void validateData(EventNotificationSpaceController controller, List<Message> messages) {
        EventNotificationPane notificationPane = (EventNotificationPane)controller.getView().getMainTile().getFullNode();
        EventNotificationMainPane mainPane = (EventNotificationMainPane)notificationPane.getMainCard().getContent();
        if (!mainPane.getActiveNode().getValue()) {
            return;
        }
        if (mainPane.getEventDateNode().getValue() == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Notification_validation_missing_event_date, (Object[])new Object[0]));
        } else if (mainPane.getAlarmDateNode().getValue() == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Notification_validation_missing_alarm_date, (Object[])new Object[0]));
        } else if (mainPane.getAlarmDateNode().getValue().isBefore(LocalDateTime.now())) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Notification_validation_alarm_date_arrived, (Object[])new Object[0]));
        }
        if (TextUtil.isBlank((String)mainPane.getTitleNode().getValue())) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_validation_missing_title, (Object[])new Object[0]));
        }
        if (TextUtil.isBlank((String)mainPane.getTitleNode().getValue())) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_validation_missing_text, (Object[])new Object[0]));
        }
        if (((TableWidget)notificationPane.getRecipientsCard().getContent()).getRowsCount() == 0) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Notification_validation_missing_recipients, (Object[])new Object[0]));
        }
    }
}

