/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.tripartitecontract;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.profile.TripContractClientsFilterPanel;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullClientVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullGeneral;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullGeneralSuppliersVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractProviderVM;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpaceVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.notifications.EventNotificationTool;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CarsSupplier;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.HotelsBrandType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractSubtype;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.tripartite.TripartiteContractFilteringCategories;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class TripartiteContractControllerInterceptor
extends ControllerInterceptor<TripartiteContractSpaceVM, TripartiteContractSpaceController> {
    protected Class<TripartiteContractSpaceController> getControllerClass() {
        return TripartiteContractSpaceController.class;
    }

    protected void onCreate(TripartiteContractSpaceController controller) {
        TripartiteContractFullPanel view = (TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode();
        ((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getAgencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ((EntityBoxWidgetColumn)((TableWidget)view.getClientsCard().getContent()).getColumn("client")).setListParametersSupplier(ControllerInterceptorsHelper::getClients);
        ((TableWidget)view.getClientsCard().getContent()).setFiltering(() -> new TripContractClientsFilterPanel(false), TripartiteContractControllerInterceptor::clientsFilteringPredicate, true);
        if (Prefetched.getData().isNotificationsEnabled()) {
            view.getClientsCard().getActions().add(this.createNotificationAction(view));
        }
        ArrayList<RendererWidgetColumn<TripartiteContractFullGeneralSuppliersVM>> columns = new ArrayList<RendererWidgetColumn<TripartiteContractFullGeneralSuppliersVM>>();
        RendererWidgetColumn<TripartiteContractFullGeneralSuppliersVM> columnSuppliers = TripartiteContractControllerInterceptor.createColumnWidget();
        columns.add(columnSuppliers);
        ((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getSuppliersNode().setColumns(columns);
        ArrayList<RendererWidgetColumn<TripartiteContractProviderVM>> columns2 = new ArrayList<RendererWidgetColumn<TripartiteContractProviderVM>>();
        RendererWidgetColumn<TripartiteContractProviderVM> columnProviders = TripartiteContractControllerInterceptor.createColumnWidgetProvider();
        columns2.add(columnProviders);
        ((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getProviderNode().setColumns(columns2);
        ((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getContractSubtypeNode().setNoNulls(true);
    }

    protected void beforeReadData(TripartiteContractSpaceController controller, TripartiteContractSpaceVM model) {
        RulesViewConfiguration config = new RulesViewConfiguration();
        config.setTargetsSupplier(() -> {
            ArrayList<Targets> result = new ArrayList<Targets>();
            if (model.getMainFull().getGeneral().getContractType() != null) {
                if (model.getMainFull().getGeneral().getContractType().equals((Object)TripartiteContractType.AVIA)) {
                    result.add(Targets.PRODUCT_COMMISSION);
                } else if (model.getMainFull().getGeneral().getContractType().equals((Object)TripartiteContractType.CAR)) {
                    result.add(Targets.CAR);
                } else if (model.getMainFull().getGeneral().getContractType().equals((Object)TripartiteContractType.HOTEL)) {
                    result.add(Targets.HOTELS_FOREIGN);
                }
            }
            return result;
        });
        config.setActionsSupplier(target -> RulesEnvironment.get().getActions(target).stream().filter(action -> {
            boolean flag = false;
            for (RuleFilteringCategory category : RulesEnvironment.get().getFilteringCategories()) {
                if (!TripartiteContractControllerInterceptor.checkFilteringCategory(category, model.getMainFull().getGeneral().getContractSubtype()) || !RulesEnvironment.get().getActions(category).contains(action) || !RulesEnvironment.get().getTargets(category).contains(target)) continue;
                flag = true;
            }
            return flag;
        }).collect(Collectors.toList()));
        config.getFilters().addAll(Arrays.asList(StandardFilters.values()));
        config.getCustomProperties().set("tripartiteContract", () -> controller.getMainFull().getGeneral().getContractSubtype());
        RulesWidgetHelper.initTile((Tile<Node, CustomWidget<RuleSet>>)controller.getView().getRulesTile(), config);
        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().valueProperty().addListener((obj, oldValue, newValue) -> TripartiteContractControllerInterceptor.createSuppliersWidget(controller));
    }

    private static void createSuppliersWidget(TripartiteContractSpaceController controller) {
        if (((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().valueProperty().get() != null) {
            ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().removeAllRows();
            switch ((TripartiteContractSubtype)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().valueProperty().get()) {
                case AVIA_AIRLINES: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setCaption(Messages.Suppliers_airlines);
                    RendererWidgetColumn column = (RendererWidgetColumn)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getColumn("value");
                    column.setRenderer(TripartiteContractControllerInterceptor.createNodeRenderer(Airline.class));
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    break;
                }
                case AVIA_ALLIANCES: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setCaption(Messages.Suppliers_airline_alliances);
                    RendererWidgetColumn column = (RendererWidgetColumn)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getColumn("value");
                    column.setRenderer(TripartiteContractControllerInterceptor.createNodeRenderer(AirlineAlliance.class));
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    break;
                }
                case CARS_GLOBAL: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setHidden(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(true);
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    break;
                }
                case CARS_BRAND: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setHidden(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setCaption(Messages.Auto_suppliers);
                    RendererWidgetColumn column = (RendererWidgetColumn)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getColumn("value");
                    column.setRenderer(TripartiteContractControllerInterceptor.createNodeRenderer(CarsSupplier.class));
                    break;
                }
                case HOTEL_GLOBAL: {
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setHidden(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(true);
                    break;
                }
                case HOTEL_CHAIN: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setHidden(false);
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setCaption(Messages.Suppliers_of_hotels);
                    RendererWidgetColumn column = (RendererWidgetColumn)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getColumn("value");
                    column.setRenderer(TripartiteContractControllerInterceptor.createHotelRenderer(controller));
                    break;
                }
                case HOTEL_BRAND: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setHidden(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setCaption(Messages.Suppliers_of_hotels);
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    RendererWidgetColumn column = (RendererWidgetColumn)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getColumn("value");
                    column.setRenderer(TripartiteContractControllerInterceptor.createHotelRenderer(controller));
                    break;
                }
                case HOTEL_PROVIDERS: {
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersCell().setHidden(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderCell().setHidden(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderNode().getViewState().setReadonly(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderNode().getViewState().setNotEditable(false);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderCell().setCaption(Messages.Hotels_provider);
                    RendererWidgetColumn column = (RendererWidgetColumn)((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderNode().getColumn("value");
                    column.setRenderer((NodeRenderer)StandardNodeRenderer.ENUMBOX_HOTEL_PROVIDER);
                    break;
                }
                default: {
                    TripartiteContractControllerInterceptor.blockProviderField(controller);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().removeAllRows();
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(true);
                    ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(true);
                    break;
                }
            }
        } else {
            ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().removeAllRows();
            ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setReadonly(true);
            ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getSuppliersNode().getViewState().setNotEditable(true);
        }
    }

    private static void blockProviderField(TripartiteContractSpaceController controller) {
        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderCell().setHidden(true);
        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderNode().getViewState().setReadonly(true);
        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getProviderNode().getViewState().setNotEditable(true);
    }

    private static RendererWidgetColumn<TripartiteContractFullGeneralSuppliersVM> createColumnWidget() {
        RendererWidgetColumn column = new RendererWidgetColumn(TripartiteContractFullGeneralSuppliersVM::getDictValue, (dictVM, dictValue) -> dictVM.setDictValue((DictionaryReference)dictValue));
        column.setId("value");
        column.setCaption(Messages.Value_text);
        return column;
    }

    private static RendererWidgetColumn<TripartiteContractProviderVM> createColumnWidgetProvider() {
        RendererWidgetColumn column = new RendererWidgetColumn(TripartiteContractProviderVM::getProvider, (providerVM, providerValue) -> providerVM.setProvider((HotelProvider)providerValue));
        column.setId("value");
        column.setCaption(Messages.Value_text);
        return column;
    }

    private static NodeRenderer createNodeRenderer(final Class<? extends BaseDictionary> dictClass) {
        return new NodeRenderer(){

            public void setValue(Node node, Object value) {
                ((DictBoxWidget)node).valueProperty().set(value);
            }

            public void setReadonly(boolean readonly, Node node) {
                ((DictBoxWidget)node).getViewState().setReadonly(readonly);
            }

            public Object getValue(Node node) {
                return ((DictBoxWidget)node).valueProperty().get();
            }

            public Node createNode(boolean readonly) {
                return new DictBoxWidget(dictClass, readonly);
            }
        };
    }

    private static NodeRenderer createHotelRenderer(final TripartiteContractSpaceController controller) {
        return new NodeRenderer(){

            public void setValue(Node node, Object value) {
                ((DictBoxWidget)node).valueProperty().set((Object)((DictionaryReference)value));
            }

            public void setReadonly(boolean readonly, Node node) {
                ((DictBoxWidget)node).getViewState().setReadonly(readonly);
            }

            public Object getValue(Node node) {
                return ((DictBoxWidget)node).valueProperty().get();
            }

            public Node createNode(boolean readonly) {
                DictBoxWidget widget = new DictBoxWidget(HotelsBrand.class, readonly);
                widget.setListParametersSupplier(() -> {
                    DictListParameters result = new DictListParameters();
                    TableColumnSettings column1 = new TableColumnSettings();
                    column1.setId(BaseDictionary.Property.code.name());
                    column1.setDisplayName(BaseDictionary.Property.code.toString());
                    column1.setRenderer((Renderer)StandardRenderers.GENERIC);
                    TableColumnSettings column2 = new TableColumnSettings();
                    column2.setId(BaseDictionary.Property.translations.name());
                    column2.setDisplayName(HotelsBrand.Property.name.toString());
                    column2.setRenderer((Renderer)StandardRenderers.TRANSLATIONS);
                    result.getColumns().add(column1);
                    result.getColumns().add(column2);
                    if (((TripartiteContractFullGeneral)((TripartiteContractFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().valueProperty() != null) {
                        switch (controller.getMainFull().getGeneral().getContractSubtype()) {
                            case HOTEL_CHAIN: {
                                result.getSearchCriterions().add(new DictQuery.SearchCriterion(HotelsBrand.Property.type.name(), new Object[]{HotelsBrandType.CHAIN_OF_BRANDS}));
                                break;
                            }
                            case HOTEL_BRAND: {
                                result.getSearchCriterions().add(new DictQuery.SearchCriterion(HotelsBrand.Property.type.name(), new Object[]{HotelsBrandType.HOTEL, HotelsBrandType.BRAND}));
                                break;
                            }
                        }
                    }
                    return result;
                });
                return widget;
            }
        };
    }

    private static boolean checkFilteringCategory(RuleFilteringCategory object, TripartiteContractSubtype contractSubtype) {
        if (contractSubtype != null) {
            switch (contractSubtype) {
                case AVIA_AIRLINES: {
                    return TripartiteContractFilteringCategories.AVIA_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case AVIA_ALLIANCES: {
                    return TripartiteContractFilteringCategories.AVIA_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case CARS_GLOBAL: {
                    return TripartiteContractFilteringCategories.CAR_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case CARS_BRAND: {
                    return TripartiteContractFilteringCategories.CAR_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case HOTEL_GLOBAL: {
                    return TripartiteContractFilteringCategories.HOTEL_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case HOTEL_CHAIN: {
                    return TripartiteContractFilteringCategories.HOTEL_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case HOTEL_BRAND: {
                    return TripartiteContractFilteringCategories.HOTEL_TRIPARTITE_CONTRACT.equals((Object)object);
                }
                case HOTEL_PROVIDERS: {
                    return TripartiteContractFilteringCategories.HOTEL_TRIPARTITE_CONTRACT.equals((Object)object);
                }
            }
        }
        return false;
    }

    private static Predicate<TripartiteContractFullClientVM> clientsFilteringPredicate(TripContractClientsFilterPanel filterPanel) {
        return vm -> {
            String searchValue = filterPanel.getSearchValueNode().getValue();
            LocalDate startDate = (LocalDate)filterPanel.getStartDateNode().valueProperty().get();
            LocalDate endDate = (LocalDate)filterPanel.getEndDateNode().valueProperty().get();
            return ControllerInterceptorsHelper.matches(searchValue, vm.getClient(), vm.getContractNumber()) && ControllerInterceptorsHelper.matches(startDate, endDate, vm.getStartDate(), vm.getEndDate());
        };
    }

    private CardAction<TableWidget<TripartiteContractFullClientVM>> createNotificationAction(final TripartiteContractFullPanel view) {
        ((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getNameNode().getViewState().stateProperty().addListener((s, o, n) -> view.getClientsCard().revalidateActions());
        return new CardAction<TableWidget<TripartiteContractFullClientVM>>(){

            public boolean isEnabled(Card<TableWidget<TripartiteContractFullClientVM>> card) {
                return !((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getNameNode().getViewState().isImmutable();
            }

            public double getWeight() {
                return 0.0;
            }

            public String getName(Card<TableWidget<TripartiteContractFullClientVM>> card) {
                return Messages.Notification_tripartite_action_name;
            }

            public String getDescription(Card<TableWidget<TripartiteContractFullClientVM>> card) {
                return Messages.Notification_tripartite_action_description;
            }

            public void execute(Card<TableWidget<TripartiteContractFullClientVM>> card, boolean alt) {
                TableWidget tableWidget = (TableWidget)view.getClientsCard().getContent();
                DateValueWidgetColumn column = (DateValueWidgetColumn)tableWidget.getColumn("endDate");
                LocalDate eventDate = null;
                for (int row = 0; row < tableWidget.getRowsCount(); ++row) {
                    LocalDate value = ((DateValueWidget)column.getWidget(row)).getValue();
                    if (value == null || eventDate != null && !eventDate.isAfter(value)) continue;
                    eventDate = value;
                }
                if (eventDate == null) {
                    Notifications.get().showFlashNotification(Messages.Notification_tripartite_missing_contract_end_date);
                    return;
                }
                if (!eventDate.isAfter(LocalDate.now().plusDays(1L))) {
                    Notifications.get().showFlashNotification(Messages.Notification_tripartite_invalid_contract_end_date);
                    return;
                }
                StringBuilder buf = new StringBuilder();
                if (!TextUtil.isBlank((String)((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getNameNode().getValue())) {
                    buf.append(Messages.Notification_tripartite_name).append(": ").append(((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getNameNode().getValue()).append('\n');
                }
                if (((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getContractSubtypeNode().getValue() != null) {
                    buf.append(Messages.Notification_tripartite_type).append(": ").append(((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getContractSubtypeNode().getValue()).append('\n');
                }
                if (((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getAgencyNode().getValue() != null) {
                    buf.append(Messages.Notification_tripartite_agency).append(": ").append(((TripartiteContractFullGeneral)view.getGeneralCard().getContent()).getAgencyNode().getValue()).append('\n');
                }
                EntityReference ref = null;
                DataTransferPackage data = RootEntityPane.lookup((Node)view).getData();
                if (data != null && data.getContainer() != null) {
                    ref = data.getContainer().toReference();
                }
                EventNotificationTool.showCreateDialog((Node)view, LocalDateTime.of(eventDate, LocalTime.NOON), Messages.Notification_tripartite_title, buf.toString(), ref);
            }
        };
    }
}

