/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.tripartitecontract;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullGeneral;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpace;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.tripartitecontract.TripartiteContractControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.tripartitecontract.TripartiteContractGeneralTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.tripartitecontract.TripartiteContractReferencesPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.util.List;

public class TripartiteContractHandler
implements RootEntityHandler<TripartiteContract, Void> {
    public TripartiteContractHandler() {
        ControllersRegistry.register((ControllerInterceptor)new TripartiteContractControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new TripartiteContractReferencesPanelControllerInterceptor());
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TripartiteContractIndex.class;
    }

    public Class<TripartiteContract> getEntityClass() {
        return TripartiteContract.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public ViewController<?, DataTransferPackage<TripartiteContract, Void>> createEditorController(final boolean ro) {
        return new ViewController<TripartiteContractSpace, DataTransferPackage<TripartiteContract, Void>>(){
            private final TripartiteContractSpaceController controller;
            private DataTransferPackage<TripartiteContract, Void> data;
            {
                this.controller = new TripartiteContractSpaceController(ro);
            }

            public TripartiteContractSpace getView() {
                return this.controller.getView();
            }

            public DataTransferPackage<TripartiteContract, Void> getData() {
                return this.data;
            }

            public void readData(DataTransferPackage<TripartiteContract, Void> model) {
                this.data = model;
                TripartiteContractSpaceVM vm = new TripartiteContractSpaceVM();
                vm.getMainFull().getGeneral().setContractType(((TripartiteContract)model.getContainer().getEntity()).getType());
                this.toVM((TripartiteContract)model.getContainer().getEntity(), vm);
                this.controller.readData(vm);
                this.setSubtypeItemSupplier((TripartiteContract)model.getContainer().getEntity());
            }

            public void writeData(DataTransferPackage<TripartiteContract, Void> model) {
                this.data = model;
                TripartiteContractSpaceVM vm = new TripartiteContractSpaceVM();
                this.toVM((TripartiteContract)model.getContainer().getEntity(), vm);
                this.controller.writeData(vm);
                this.fromVM(vm, (TripartiteContract)model.getContainer().getEntity());
            }

            public boolean isReadonly() {
                return this.controller.isReadonly();
            }

            public void setReadonly(boolean readonly) {
                this.controller.setReadonly(readonly);
            }

            public void setNotEditable(boolean notEditable) {
                this.controller.setNotEditable(notEditable);
            }

            public void setAclNotEditable(boolean aclNotEditable) {
                this.controller.setAclNotEditable(aclNotEditable);
            }

            public boolean isDataChanged() {
                return this.controller.isDataChanged();
            }

            public void validateData(List<Message> messages) {
                this.controller.validateData(messages);
            }

            private void toVM(TripartiteContract model, TripartiteContractSpaceVM vm) {
                vm.getOverview().getMain().setName(model.getName());
                vm.getOverview().getMain().setKind(model.getType() == null ? null : model.getType().toString());
                TripartiteContractGeneralTileHelper.toVM(model, vm.getMainFull(), this.controller);
                VMHelper.copy(model.getRuleSet(), vm.getRulesFull());
            }

            private void fromVM(TripartiteContractSpaceVM vm, TripartiteContract model) {
                TripartiteContractGeneralTileHelper.fromVM(vm.getMainFull(), model);
                vm.getRulesFull().getRules().forEach(rule -> {
                    if (model.getType() != null) {
                        switch (model.getType()) {
                            case AVIA: {
                                rule.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                                break;
                            }
                            case CAR: {
                                rule.setTarget((RuleTarget)Targets.CAR);
                                break;
                            }
                            case HOTEL: {
                                rule.setTarget((RuleTarget)Targets.HOTELS_FOREIGN);
                                break;
                            }
                        }
                    }
                });
                if (model.getRuleSet() == null) {
                    model.setRuleSet(new RuleSet());
                }
                VMHelper.copy(vm.getRulesFull(), model.getRuleSet());
            }

            private void setSubtypeItemSupplier(TripartiteContract model) {
                if (model.getType() == null) {
                    return;
                }
                switch (model.getType()) {
                    case AVIA: {
                        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)this.controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().setItemsSupplier(TripartiteContractGeneralTileHelper::getAviaSubtypes);
                        break;
                    }
                    case CAR: {
                        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)this.controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().setItemsSupplier(TripartiteContractGeneralTileHelper::getCarSubtypes);
                        break;
                    }
                    case HOTEL: {
                        ((TripartiteContractFullGeneral)((TripartiteContractFullPanel)this.controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getContractSubtypeNode().setItemsSupplier(TripartiteContractGeneralTileHelper::getHotelSubtypes);
                        break;
                    }
                }
            }
        };
    }

    public boolean isAvaibleInConfiguration() {
        EntityType ett = (EntityType)MetaRegistry.get().getEntities().get(this.getEntityClass().getName());
        return AppConfigHelper.isInScope(ett);
    }
}

