/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.Icon;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolDataRenamer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class IndexListNavToolData
implements XSerializable,
XSSerializable,
XCloneable {
    public static final Serializer<IndexListNavToolData> SERIALIZER = new Serializer<IndexListNavToolData>(){

        public byte[] serialize(IndexListNavToolData obj) throws Exception {
            if (obj == null) {
                return null;
            }
            return XSUtil.toByteArray((XSSerializable)obj);
        }

        public IndexListNavToolData deserialize(byte[] data) throws Exception {
            if (data == null || data.length == 0) {
                return null;
            }
            IndexListNavToolData result = new IndexListNavToolData();
            XUtil.fromBytes((byte[])data, (XSerializable)result);
            return result;
        }
    };
    private String uid;
    private Class<? extends EntityIndex<?>> indexType;
    private final List<SearchCriterion> searchCriterions = new ArrayList<SearchCriterion>();
    private final List<RestrictionGroup> restrictionGroups = new ArrayList<RestrictionGroup>();
    private int limit;
    private final Map<String, SortOrder> sortings = new LinkedHashMap<String, SortOrder>();
    private final List<TableColumnSettings> columns = new ArrayList<TableColumnSettings>();
    private final List<TableColumnSettings> filters = new ArrayList<TableColumnSettings>();
    private final List<ProjectionField> projections = new ArrayList<ProjectionField>();

    public IndexListNavToolData() {
        this.uid = UUIDGenerator.generate((boolean)false).toString();
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public Class<? extends EntityIndex<?>> getIndexType() {
        return this.indexType;
    }

    public void setIndexType(Class<? extends EntityIndex<?>> value) {
        this.indexType = value;
    }

    public List<SearchCriterion> getSearchCriterions() {
        return this.searchCriterions;
    }

    public List<RestrictionGroup> getRestrictionGroups() {
        return this.restrictionGroups;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int value) {
        this.limit = value;
    }

    public Map<String, SortOrder> getSortings() {
        return this.sortings;
    }

    public List<TableColumnSettings> getColumns() {
        return this.columns;
    }

    public List<TableColumnSettings> getFilters() {
        return this.filters;
    }

    public List<ProjectionField> getProjections() {
        return this.projections;
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeString((Element)elm, (String)"uid", (String)this.uid);
        XHelper.writeString((Element)elm, (String)"indexType", this.indexType == null ? null : this.indexType.getName());
        XHelper.writeInt((Element)elm, (String)"limit", (int)this.limit);
        for (SearchCriterion searchCriterion : this.searchCriterions) {
            searchCriterion.toXML(XmlUtil.addElement((Element)elm, (String)"criterions/item"));
        }
        for (RestrictionGroup restrictionGroup : this.restrictionGroups) {
            XHelper.writeObject((Element)elm, (String)"restrictionGroups/item", (Object)restrictionGroup);
        }
        for (Map.Entry entry : this.sortings.entrySet()) {
            String key = (String)entry.getKey();
            SortOrder value = (SortOrder)entry.getValue();
            Element entryElm = XmlUtil.addElement((Element)elm, (String)"sortings/entry");
            XHelper.writeString((Element)entryElm, (String)"key", (String)key);
            XHelper.writeEnum((Element)entryElm, (String)"value", (Enum)value);
        }
        for (TableColumnSettings tableColumnSettings : this.columns) {
            this.colSettingsToXML(tableColumnSettings, XmlUtil.addElement((Element)elm, (String)"columns/item"));
        }
        for (TableColumnSettings tableColumnSettings : this.filters) {
            this.colSettingsToXML(tableColumnSettings, XmlUtil.addElement((Element)elm, (String)"filters/item"));
        }
        for (ProjectionField projectionField : this.projections) {
            Element fieldElm = XmlUtil.addElement((Element)elm, (String)"projections/item");
            XHelper.writeString((Element)fieldElm, (String)"propertyId", (String)projectionField.getId());
            XHelper.writeString((Element)fieldElm, (String)"displayName", (String)projectionField.getDisplayName());
            XHelper.writeEnum((Element)fieldElm, (String)"operation", (Enum)projectionField.getOperation());
        }
    }

    private void colSettingsToXML(TableColumnSettings col, Element elm) {
        XHelper.writeString((Element)elm, (String)"propertyId", (String)col.getId());
        XHelper.writeString((Element)elm, (String)"displayName", (String)col.getDisplayName());
        XHelper.writeString((Element)elm, (String)"icon", col.getIcon() != null ? col.getIcon().getId() : null);
        XHelper.writeDouble((Element)elm, (String)"prefWidth", (Double)col.getPrefWidth());
        XHelper.writeString((Element)elm, (String)"renderer", col.getRenderer() != null ? col.getRenderer().getId() : null);
    }

    public void fromXML(Element elm) throws Exception {
        Collection<IndexListNavToolDataRenamer> renamers = ClientRegistry.get().allOf(IndexListNavToolDataRenamer.TYPE).values();
        this.uid = XHelper.readString((Element)elm, (String)"uid");
        this.indexType = XSHelper.getClass((String)IndexListNavToolData.renameIndexType(XHelper.readString((Element)elm, (String)"indexType"), renamers));
        this.limit = XHelper.readInt((Element)elm, (String)"limit", (int)0);
        for (Element crtElm : XmlUtil.getElements((Element)elm, (String)"criterions/item")) {
            SearchCriterion crt = SearchCriterion.readFromXML((Element)crtElm);
            if (crt == null) continue;
            this.searchCriterions.add(crt);
        }
        this.restrictionGroups.clear();
        for (Element groupElm : XmlUtil.getElements((Element)elm, (String)"restrictionGroups/item")) {
            RestrictionGroup group = (RestrictionGroup)XHelper.readObject((Element)groupElm, (String)".");
            if (group == null) continue;
            this.restrictionGroups.add(group);
        }
        this.sortings.clear();
        for (Element entryElm : XmlUtil.getElements((Element)elm, (String)"sortings/entry")) {
            Element keyElm = XmlUtil.getElement((Element)entryElm, (String)"key");
            Element valueElm = XmlUtil.getElement((Element)entryElm, (String)"value");
            String key = XHelper.readString((Element)keyElm, (String)".");
            SortOrder value = (SortOrder)XHelper.readEnum((Element)valueElm, (String)".", SortOrder.class);
            if (key == null || value == null) continue;
            this.sortings.put(key, value);
        }
        this.columns.clear();
        for (Element colElm : XmlUtil.getElements((Element)elm, (String)"columns/item")) {
            this.columns.add(this.colSettingsFromXML(colElm));
        }
        this.filters.clear();
        for (Element colElm : XmlUtil.getElements((Element)elm, (String)"filters/item")) {
            this.filters.add(this.colSettingsFromXML(colElm));
        }
        this.projections.clear();
        for (Element prjElm : XmlUtil.getElements((Element)elm, (String)"projections/item")) {
            ProjectionField field = new ProjectionField();
            field.setId(XHelper.readString((Element)prjElm, (String)"propertyId"));
            field.setDisplayName(XHelper.readString((Element)prjElm, (String)"displayName"));
            field.setOperation((ProjectionField.Operation)XHelper.readEnum((Element)prjElm, (String)"operation", ProjectionField.Operation.class));
            this.projections.add(field);
        }
    }

    private static String renameIndexType(String indexType, Collection<IndexListNavToolDataRenamer> renamers) {
        String result = indexType;
        for (IndexListNavToolDataRenamer renamer : renamers) {
            result = renamer.renameIndexType(result);
        }
        return result;
    }

    private TableColumnSettings colSettingsFromXML(Element elm) {
        TableColumnSettings result = new TableColumnSettings();
        result.setId(XHelper.readString((Element)elm, (String)"propertyId"));
        result.setDisplayName(XHelper.readString((Element)elm, (String)"displayName"));
        String icon = XHelper.readString((Element)elm, (String)"icon");
        result.setIcon(icon != null ? Icon.forId((String)icon) : null);
        result.setPrefWidth(XHelper.readDouble((Element)elm, (String)"prefWidth"));
        String renderer = XHelper.readString((Element)elm, (String)"renderer");
        result.setRenderer(renderer != null ? Renderer.forId((String)renderer) : null);
        return result;
    }

    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"uid", (String)this.uid);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"indexType", this.indexType == null ? null : this.indexType.getName());
        XSHelper.writeInt((XMLStreamWriter)writer, (String)"limit", (int)this.limit);
        if (!this.searchCriterions.isEmpty()) {
            writer.writeStartElement("criterions");
            for (SearchCriterion searchCriterion : this.searchCriterions) {
                writer.writeStartElement("item");
                searchCriterion.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (!this.restrictionGroups.isEmpty()) {
            writer.writeStartElement("restrictionGroups");
            for (RestrictionGroup restrictionGroup : this.restrictionGroups) {
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)restrictionGroup);
            }
            writer.writeEndElement();
        }
        if (!this.sortings.isEmpty()) {
            writer.writeStartElement("sortings");
            for (Map.Entry entry : this.sortings.entrySet()) {
                writer.writeStartElement("entry");
                String key = (String)entry.getKey();
                SortOrder value = (SortOrder)entry.getValue();
                XSHelper.writeString((XMLStreamWriter)writer, (String)"key", (String)key);
                XSHelper.writeEnum((XMLStreamWriter)writer, (String)"value", (Enum)value);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (!this.columns.isEmpty()) {
            writer.writeStartElement("columns");
            for (TableColumnSettings tableColumnSettings : this.columns) {
                writer.writeStartElement("item");
                this.writeColSettings(writer, tableColumnSettings);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (!this.filters.isEmpty()) {
            writer.writeStartElement("filters");
            for (TableColumnSettings tableColumnSettings : this.filters) {
                writer.writeStartElement("item");
                this.writeColSettings(writer, tableColumnSettings);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (!this.projections.isEmpty()) {
            writer.writeStartElement("projections");
            for (ProjectionField projectionField : this.projections) {
                writer.writeStartElement("item");
                XSHelper.writeString((XMLStreamWriter)writer, (String)"propertyId", (String)projectionField.getId());
                XSHelper.writeString((XMLStreamWriter)writer, (String)"displayName", (String)projectionField.getDisplayName());
                XSHelper.writeEnum((XMLStreamWriter)writer, (String)"operation", (Enum)projectionField.getOperation());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeColSettings(XMLStreamWriter writer, TableColumnSettings col) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"propertyId", (String)col.getId());
        XSHelper.writeString((XMLStreamWriter)writer, (String)"displayName", (String)col.getDisplayName());
        XSHelper.writeString((XMLStreamWriter)writer, (String)"icon", col.getIcon() != null ? col.getIcon().getId() : null);
        XSHelper.writeDouble((XMLStreamWriter)writer, (String)"prefWidth", (Double)col.getPrefWidth());
        XSHelper.writeString((XMLStreamWriter)writer, (String)"renderer", col.getRenderer() != null ? col.getRenderer().getId() : null);
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        throw new UnsupportedOperationException();
    }

    public final Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        IndexListNavToolData result = new IndexListNavToolData();
        result.uid = XCloneHelper.getNewUid((String)this.uid, (boolean)newUids, uids);
        result.indexType = this.indexType;
        result.limit = this.limit;
        result.getSearchCriterions().clear();
        result.getSearchCriterions().addAll(XCloneHelper.cloneCollection(this.searchCriterions, (boolean)newUids, uids));
        result.getRestrictionGroups().clear();
        result.getRestrictionGroups().addAll(XCloneHelper.cloneCollection(this.restrictionGroups, (boolean)newUids, uids));
        result.getSortings().clear();
        for (Map.Entry<String, SortOrder> entry : this.sortings.entrySet()) {
            result.getSortings().put(entry.getKey(), entry.getValue());
        }
        result.columns.clear();
        for (TableColumnSettings column : this.columns) {
            result.columns.add(this.cloneColSettings(column));
        }
        result.filters.clear();
        for (TableColumnSettings filter : this.filters) {
            result.filters.add(this.cloneColSettings(filter));
        }
        result.projections.clear();
        for (ProjectionField field : this.projections) {
            ProjectionField copy = new ProjectionField();
            copy.setId(field.getId());
            copy.setDisplayName(field.getDisplayName());
            copy.setOperation(field.getOperation());
            result.projections.add(copy);
        }
        return result;
    }

    private TableColumnSettings cloneColSettings(TableColumnSettings column) {
        TableColumnSettings result = new TableColumnSettings();
        result.setId(column.getId());
        result.setDisplayName(column.getDisplayName());
        result.setIcon(column.getIcon() != null ? Icon.forId((String)column.getIcon().getId()) : null);
        result.setPrefWidth(column.getPrefWidth());
        result.setRenderer(column.getRenderer() != null ? Renderer.forId((String)column.getRenderer().getId()) : null);
        return result;
    }
}

