/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexListNavToolParameters {
    private static final Logger log = LoggerFactory.getLogger(IndexListNavToolParameters.class);

    static IndexListNavToolData clone(IndexListNavToolData parameters) throws Exception {
        return (IndexListNavToolData)XCloneHelper.clone((XCloneable)parameters, (boolean)true);
    }

    static IndexListNavToolData clean(IndexListNavToolData parameters) {
        if (parameters == null || parameters.getIndexType() == null) {
            return null;
        }
        IndexType indexType = MetaRegistryHelper.getIndexType((String)parameters.getIndexType().getName());
        if (indexType == null) {
            return null;
        }
        IndexListNavToolParameters.dump("== BEFORE CLEAN =========================", parameters);
        RestrictionsHelper.cleanRestrictions(parameters.getRestrictionGroups(), value -> RestrictionsHelper.isConsistent((RestrictionValue)value) && IndexListNavToolParameters.isKnownField(indexType, value.getPropertyId()));
        Iterator<Map.Entry<String, SortOrder>> it = parameters.getSortings().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SortOrder> entry = it.next();
            if (entry.getKey() != null && entry.getValue() != null && IndexListNavToolParameters.isKnownField(indexType, entry.getKey())) continue;
            it.remove();
        }
        IndexListNavToolParameters.cleanColumnSettings(indexType, parameters.getColumns());
        IndexListNavToolParameters.cleanColumnSettings(indexType, parameters.getFilters());
        IndexListNavToolParameters.cleanProjections(indexType, parameters.getProjections());
        IndexListNavToolParameters.dump("== AFTER CLEAN ==========================", parameters);
        return parameters;
    }

    private static boolean isKnownField(IndexType indexType, String fieldId) {
        String key = fieldId;
        if (key.startsWith(indexType.getId() + '.')) {
            key = key.substring(indexType.getId().length() + 1);
        }
        return "containerUid".equals(key) || indexType.getProperties().containsKey(key) || indexType.getCollections().containsKey(key);
    }

    private static void cleanColumnSettings(IndexType indexType, Collection<TableColumnSettings> settings) {
        Iterator<TableColumnSettings> it = settings.iterator();
        while (it.hasNext()) {
            TableColumnSettings sets = it.next();
            if (sets.getId() != null && IndexListNavToolParameters.isKnownField(indexType, sets.getId())) continue;
            it.remove();
        }
    }

    private static void cleanProjections(IndexType indexType, Collection<ProjectionField> settings) {
        Iterator<ProjectionField> it = settings.iterator();
        while (it.hasNext()) {
            ProjectionField field = it.next();
            if (field.getId() != null && IndexListNavToolParameters.isKnownField(indexType, field.getId())) continue;
            it.remove();
        }
    }

    private static void dump(String title, IndexListNavToolData data) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("\n");
            if (title != null) {
                buf.append(title);
                buf.append("\n");
            }
            buf.append(DebugUtil.decorate((String)IndexListNavToolParameters.toString(data), null, (String)"parameters", (boolean)true));
            log.debug(buf.toString());
        }
    }

    private static String toString(IndexListNavToolData parameters) {
        StringBuilder buf = new StringBuilder();
        buf.append("indexType -> " + parameters.getIndexType());
        buf.append("\n");
        buf.append("limit -> " + parameters.getLimit());
        buf.append("\n");
        buf.append(DebugUtil.decorate((String)FxUtil.toString(parameters.getRestrictionGroups(), value -> value.getType() != RestrictionGroupType.SIMPLE && value.getType() != RestrictionGroupType.NOT ? (List)value.getValue() : Collections.emptyList(), value -> RestrictionsHelper.toString((RestrictionGroup)value)), null, (String)"restrictions", (boolean)true));
        buf.append(DebugUtil.decorate((Iterable)parameters.getSortings().entrySet().stream().map(value -> IndexListNavToolParameters.toString((String)value.getKey(), (SortOrder)value.getValue())).collect(Collectors.toList()), null, (String)"sortings", (boolean)true));
        buf.append(DebugUtil.decorate((Iterable)parameters.getColumns().stream().map(value -> IndexListNavToolParameters.toString(value)).collect(Collectors.toList()), null, (String)"columns", (boolean)true));
        buf.append(DebugUtil.decorate((Iterable)parameters.getFilters().stream().map(value -> IndexListNavToolParameters.toString(value)).collect(Collectors.toList()), null, (String)"filters", (boolean)true));
        buf.append(DebugUtil.decorate((Iterable)parameters.getProjections().stream().map(value -> IndexListNavToolParameters.toString(value)).collect(Collectors.toList()), null, (String)"projections", (boolean)true));
        return buf.toString();
    }

    private static String toString(String columnId, SortOrder sortOrder) {
        StringBuilder buf = new StringBuilder();
        buf.append("columnId -> " + columnId);
        buf.append("\n");
        buf.append("sortOrder -> " + sortOrder);
        return buf.toString();
    }

    private static String toString(TableColumnSettings settings) {
        StringBuilder buf = new StringBuilder();
        buf.append("id -> " + settings.getId());
        buf.append("\n");
        buf.append("displayName -> " + settings.getDisplayName());
        buf.append("\n");
        buf.append("type -> " + settings.getType());
        return buf.toString();
    }

    private static String toString(ProjectionField field) {
        StringBuilder buf = new StringBuilder();
        buf.append("id -> " + field.getId());
        buf.append("\n");
        buf.append("displayName -> " + field.getDisplayName());
        buf.append("\n");
        buf.append("operation -> " + field.getOperation());
        return buf.toString();
    }

    private IndexListNavToolParameters() {
    }
}

