/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

class IndexListNavToolProjectionsEditor
extends StackPane
implements NavToolEditor,
DevTool {
    private TableWidgetController<TableWidget<ProjectionField>, ProjectionField> controller = new TableWidgetController<TableWidget<ProjectionField>, ProjectionField>(){
        private final TableWidget<ProjectionField> view = new TableWidget(false);

        public TableWidget<ProjectionField> getView() {
            return this.view;
        }
    };
    IndexType indexType;
    private boolean dataReading;

    IndexListNavToolProjectionsEditor() {
        ((TableWidget)this.controller.getView()).setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        ((TableWidget)this.controller.getView()).setItemsProvider(() -> {
            ProjectionField result = new ProjectionField();
            result.setOperation(ProjectionField.Operation.COUNT);
            result.setId("containerUid");
            result.setDisplayName(Messages.Records_count);
            return result;
        });
        ComboBoxWidgetColumn operationColumn = new ComboBoxWidgetColumn(ProjectionField::getOperation, ProjectionField::setOperation);
        operationColumn.setNoNulls(true);
        operationColumn.setItemsSupplier(Suppliers.createEnumSupplier(ProjectionField.Operation.class));
        operationColumn.setConverter((StringConverter)new StringConverter<ProjectionField.Operation>(){

            public String toString(ProjectionField.Operation object) {
                if (object == null) {
                    return null;
                }
                switch (object) {
                    case AVERAGE: {
                        return Messages.Projection_op_average;
                    }
                    case COUNT: {
                        return Messages.Projection_op_count;
                    }
                    case MAX: {
                        return Messages.Projection_op_max;
                    }
                    case MIN: {
                        return Messages.Projection_op_min;
                    }
                    case SUM: {
                        return Messages.Projection_op_sum;
                    }
                }
                return null;
            }

            public ProjectionField.Operation fromString(String string) {
                return null;
            }
        });
        operationColumn.setCaption(Messages.Projection_operation);
        operationColumn.setId("operation");
        operationColumn.setPrefWidth(Double.valueOf(30.0));
        operationColumn.setLive(true);
        operationColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(operationColumn.getConverter(), operationColumn.getItemsSupplier(), operationColumn.isSortItems()));
        ComboBoxWidgetColumn fieldColumn = new ComboBoxWidgetColumn(ProjectionField::getId, ProjectionField::setId);
        fieldColumn.setNoNulls(true);
        fieldColumn.setItemsSupplier(() -> {
            if (this.indexType == null) {
                return Collections.emptyList();
            }
            return this.indexType.getProperties().values().stream().filter(prop -> {
                if (!prop.isViewable() || !prop.isFilterable() && !prop.isSearchable()) {
                    return false;
                }
                switch (prop.getType()) {
                    case "byte": 
                    case "Byte": 
                    case "char": 
                    case "Character": 
                    case "short": 
                    case "Short": 
                    case "int": 
                    case "Integer": 
                    case "long": 
                    case "Long": 
                    case "float": 
                    case "Float": 
                    case "double": 
                    case "Double": 
                    case "java.math.BigInteger": 
                    case "java.math.BigDecimal": {
                        return true;
                    }
                }
                return false;
            }).map(BaseMetaElement::getId).collect(Collectors.toList());
        });
        fieldColumn.setConverter((StringConverter)new StringConverter<String>(){

            public String toString(String object) {
                if (IndexListNavToolProjectionsEditor.this.indexType == null || object == null) {
                    return object;
                }
                if ("containerUid".equals(object)) {
                    return Messages.Object_id;
                }
                IndexProperty prop = (IndexProperty)IndexListNavToolProjectionsEditor.this.indexType.getProperties().get(object);
                return prop == null ? object : prop.getDisplayName();
            }

            public String fromString(String string) {
                return null;
            }
        });
        fieldColumn.setCaption(Messages.Projection_field);
        fieldColumn.setId("field");
        fieldColumn.setPrefWidth(Double.valueOf(30.0));
        fieldColumn.setLive(true);
        fieldColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(fieldColumn.getConverter(), fieldColumn.getItemsSupplier(), fieldColumn.isSortItems()));
        TextWidgetColumn displayNameColumn = new TextWidgetColumn(ProjectionField::getDisplayName, ProjectionField::setDisplayName);
        displayNameColumn.setCaption(Messages.Projection_name);
        displayNameColumn.setId("displayName");
        ((TableWidget)this.controller.getView()).setColumns(Arrays.asList(operationColumn, fieldColumn, displayNameColumn));
        ((TableWidget)this.controller.getView()).setOnRowsAction(event -> {
            if (event.getEventType() != TableRowEvent.ROW_ADD) {
                return;
            }
            ComboBoxWidget operationWidget = (ComboBoxWidget)operationColumn.getWidget(event.getRowIndex().intValue());
            ComboBoxWidget fieldWidget = (ComboBoxWidget)fieldColumn.getWidget(event.getRowIndex().intValue());
            TextFieldWidget displayNameWidget = (TextFieldWidget)displayNameColumn.getWidget(event.getRowIndex().intValue());
            FxUtil.addListener((ObservableValue)operationWidget.valueProperty(), (s, o, n) -> {
                if (ProjectionField.Operation.COUNT == n) {
                    fieldWidget.getViewState().setNotEditable(true);
                    fieldWidget.setValue((Object)"containerUid");
                    displayNameWidget.setValue(Messages.Records_count);
                    return;
                }
                fieldWidget.getViewState().setNotEditable(false);
                if (!this.dataReading) {
                    fieldWidget.setValue(null);
                    displayNameWidget.setValue(null);
                }
            });
        });
        this.getChildren().add((Object)this.controller.getView());
    }

    public Card<? extends Node> getContent() {
        return new Card("projections", UiCardsContainer.Style.COLLAPSED, Messages.Counters, (Node)this);
    }

    public boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(FxWorkspaceItem item) {
        this.dataReading = true;
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data = (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data != null) {
                this.indexType = data.getIndexType() != null ? (IndexType)MetaRegistry.get().getIndexes().get(data.getIndexType().getName()) : null;
                this.controller.readData(data.getProjections());
            } else {
                this.indexType = null;
                this.controller.readData(Collections.emptyList());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            this.controller.readData(Collections.emptyList());
        }
        finally {
            this.dataReading = false;
        }
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data;
            IndexListNavToolData indexListNavToolData = data = item.getParameters() != null ? (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters())) : (IndexListNavToolData)tool.createParameters();
            if (data != null) {
                this.controller.writeData(data.getProjections());
                item.setParameters(tool.getSerializer().serialize((Object)data));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(IndexListNavToolProjectionsEditor.this.controller.getView());
            }

            public String getInfo() {
                return ((Object)((Object)IndexListNavToolProjectionsEditor.this)).getClass().getSimpleName();
            }
        };
    }
}

