/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.StandardTableWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolHelper;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.MetaField;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

class IndexListNavToolSortingsEditor
extends StackPane
implements NavToolEditor,
DevTool {
    static final Predicate<IndexProperty> PROP_FILTER = item -> item.isViewable() && item.isSearchable();
    static final Predicate<IndexCollection> COLL_FILTER = item -> false;
    final TableWidgetController<TableWidget<TableSortingWrapper>, TableSortingWrapper> tableController = new TableWidgetController<TableWidget<TableSortingWrapper>, TableSortingWrapper>(){
        private final TableWidget<TableSortingWrapper> view = new TableWidget(false);
        {
            this.view.setPlaceholder(Messages.No_data);
        }

        public TableWidget<TableSortingWrapper> getView() {
            return this.view;
        }
    };
    IndexType indexType;

    IndexListNavToolSortingsEditor() {
        ((TableWidget)this.tableController.getView()).setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        ((TableWidget)this.tableController.getView()).setControlButtonsCoordinator((BiPredicate)new StandardTableWidgetCoordinator((TableWidget)this.tableController.getView()){

            public boolean test(ControlsPane.ButtonType buttonType, Integer rowNumber) {
                if (buttonType == ControlsPane.ButtonType.ADD) {
                    return IndexListNavToolHelper.getAvailableFields(IndexListNavToolSortingsEditor.this.indexType, PROP_FILTER, COLL_FILTER).size() > ((TableWidget)IndexListNavToolSortingsEditor.this.tableController.getView()).getRowsCount();
                }
                return super.test(buttonType, rowNumber);
            }
        });
        ((TableWidget)this.tableController.getView()).setItemsProvider(() -> {
            TableSortingWrapper result = new TableSortingWrapper();
            result.sortOrder = SortOrder.ASC;
            return result;
        });
        ArrayList<ComboBoxWidgetColumn> columns = new ArrayList<ComboBoxWidgetColumn>();
        ComboBoxWidgetColumn column = new ComboBoxWidgetColumn(settings -> settings.field, (settings, value) -> {
            settings.field = value;
        });
        column.setNoNulls(true);
        column.setItemsSupplier(() -> {
            if (this.indexType == null) {
                return Collections.emptyList();
            }
            Set<String> usedFields = this.getUsedFields();
            return IndexListNavToolHelper.getAvailableFields(this.indexType, PROP_FILTER, COLL_FILTER).stream().filter(item -> !usedFields.contains(item.getId())).collect(Collectors.toList());
        });
        column.setConverter((StringConverter)new StringConverter<MetaField>(){

            public String toString(MetaField object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public MetaField fromString(String string) {
                return null;
            }
        });
        column.setCaption(Messages.Name);
        column.setId("field");
        column.setPrefWidth(Double.valueOf(50.0));
        column.setLive(true);
        column.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(column.getConverter(), column.getItemsSupplier(), column.isSortItems()));
        columns.add(column);
        column = new ComboBoxWidgetColumn(settings -> settings.sortOrder, (settings, value) -> {
            settings.sortOrder = value;
        });
        column.setNoNulls(true);
        column.setItemsSupplier(Suppliers.createEnumSupplier(SortOrder.class));
        column.setConverter(Converters.SORT_ORDER_CONVERTER);
        column.setCaption(Messages.Sorting);
        column.setId("sorting");
        columns.add(column);
        ((TableWidget)this.tableController.getView()).setColumns(columns);
        this.getChildren().setAll((Object[])new Node[]{this.tableController.getView()});
    }

    private Set<String> getUsedFields() {
        ComboBoxWidgetColumn column = (ComboBoxWidgetColumn)((TableWidget)this.tableController.getView()).getColumn("field");
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < ((TableWidget)this.tableController.getView()).getRowsCount(); ++i) {
            ComboBoxWidget indexFieldComboBox = (ComboBoxWidget)column.getWidget(i);
            MetaField value = (MetaField)indexFieldComboBox.getValue();
            if (value == null) continue;
            result.add(((MetaField)indexFieldComboBox.getValue()).getId());
        }
        return result;
    }

    public Card<Node> getContent() {
        return new Card("sortings", UiCardsContainer.Style.COLLAPSED, Messages.Sorts, (Node)this);
    }

    private Collection<TableSortingWrapper> wrap(Map<String, SortOrder> sortings) {
        if (this.indexType == null) {
            return Collections.emptyList();
        }
        ArrayList<TableSortingWrapper> result = new ArrayList<TableSortingWrapper>(sortings.size());
        Map<String, MetaField> fields = IndexListNavToolHelper.getAvailableFields(this.indexType, PROP_FILTER, COLL_FILTER).stream().collect(Collectors.toMap(value -> value.getId(), value -> value));
        for (Map.Entry<String, SortOrder> entry : sortings.entrySet()) {
            MetaField field = fields.get(entry.getKey());
            if (field == null) continue;
            TableSortingWrapper wrapper = new TableSortingWrapper();
            wrapper.field = field;
            wrapper.sortOrder = entry.getValue();
            result.add(wrapper);
        }
        return result;
    }

    private Map<String, SortOrder> unwrap(List<TableSortingWrapper> tableSortingWrappers) {
        if (this.indexType == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, SortOrder> result = new LinkedHashMap<String, SortOrder>();
        Set fieldIds = IndexListNavToolHelper.getAvailableFields(this.indexType, PROP_FILTER, COLL_FILTER).stream().map(field -> field.getId()).collect(Collectors.toSet());
        for (TableSortingWrapper wrapper : tableSortingWrappers) {
            if (wrapper.field == null || !fieldIds.contains(wrapper.field.getId())) continue;
            result.put(wrapper.field.getId(), wrapper.sortOrder);
        }
        return result;
    }

    public boolean isDataChanged() {
        return this.tableController.isDataChanged();
    }

    public void readData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data = (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data != null) {
                this.indexType = data.getIndexType() != null ? (IndexType)MetaRegistry.get().getIndexes().get(data.getIndexType().getName()) : null;
                this.tableController.readData(this.wrap(data.getSortings()));
            } else {
                this.tableController.readData(Collections.emptyList());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            this.tableController.readData(Collections.emptyList());
        }
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data;
            IndexListNavToolData indexListNavToolData = data = item.getParameters() != null ? (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters())) : (IndexListNavToolData)tool.createParameters();
            if (data != null) {
                ArrayList<TableSortingWrapper> wrappers = new ArrayList<TableSortingWrapper>();
                this.tableController.writeData(wrappers);
                data.getSortings().clear();
                data.getSortings().putAll(this.unwrap(wrappers));
                item.setParameters(tool.getSerializer().serialize((Object)data));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(IndexListNavToolSortingsEditor.this.tableController.getView());
            }

            public String getInfo() {
                return ((Object)((Object)IndexListNavToolSortingsEditor.this)).getClass().getSimpleName();
            }
        };
    }

    private static class TableSortingWrapper {
        MetaField field;
        SortOrder sortOrder;

        TableSortingWrapper() {
        }
    }
}

