/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsSupplier;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.factory.basic.BalanceFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.BookingFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.ContractsFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.FinanceFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.OtherFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.PersonalDataFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.ProfileFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.StockOrderFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.SupportFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.SystemSettingsFactoryTools;
import com.gridnine.xtrip.client.fx.standard.factory.basic.UniversalProductTool;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class BasicFactoryToolsSupplier
implements FactoryToolsSupplier {
    private Collection<FactoryTool> standardTools;
    private Collection<FactoryTool> universalProductTools;

    public String getId() {
        return "basic-factory-tools-supplier";
    }

    public Collection<FactoryTool> get() {
        ArrayList<FactoryTool> result = new ArrayList<FactoryTool>();
        if (this.standardTools == null) {
            this.standardTools = BasicFactoryToolsSupplier.collectStandardTools();
        }
        result.addAll(this.standardTools);
        try {
            if (this.universalProductTools == null) {
                this.universalProductTools = this.collectUniversalProductTools();
            }
            result.addAll(this.universalProductTools);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return result;
    }

    private static List<FactoryTool> collectStandardTools() {
        ArrayList<FactoryTool> result = new ArrayList<FactoryTool>();
        Collector collector = Collectors.toCollection(() -> result);
        Arrays.stream(BookingFactoryTools.values()).collect(collector);
        Arrays.stream(ProfileFactoryTools.values()).collect(collector);
        Arrays.stream(ContractsFactoryTools.values()).collect(collector);
        Arrays.stream(FinanceFactoryTools.values()).collect(collector);
        Arrays.stream(BalanceFactoryTools.values()).collect(collector);
        Arrays.stream(StockOrderFactoryTools.values()).collect(collector);
        Arrays.stream(SystemSettingsFactoryTools.values()).collect(collector);
        Arrays.stream(SupportFactoryTools.values()).collect(collector);
        Arrays.stream(PersonalDataFactoryTools.values()).collect(collector);
        Arrays.stream(OtherFactoryTools.values()).collect(collector);
        return result;
    }

    private List<FactoryTool> collectUniversalProductTools() throws Exception {
        return Prefetched.getData().getUniversalProductDescriptionData().stream().filter(data -> !data.getData().isDisabled()).map(UniversalProductTool::new).collect(Collectors.toList());
    }
}

