/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateOrganizationHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;

enum ProfileFactoryTools implements FactoryTool
{
    PERSON_AGENT{

        public String getName() {
            return Messages.Dimension_agent;
        }

        public void execute() {
            Person person = new Person();
            person.getTypes().add(PersonType.AGENT);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)person), (Object)new PersonUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PERSON.getId()).build();
        }
    }
    ,
    ORGANIZATION_AGENCY{

        public String getName() {
            return Messages.Agency;
        }

        public void execute() {
            Organization org = new Organization();
            org.getTypes().add(OrganizationType.AGENCY);
            CreateOrganizationHelper.createOrganization(org);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)org), (Object)new OrganizationUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_ORGANIZATION.getId()).build();
        }
    }
    ,
    ORGANIZATION_TECHNICAL_PROVIDER{

        public String getName() {
            return Messages.TechnicalProvider;
        }

        public void execute() {
            Organization org = new Organization();
            org.getTypes().add(OrganizationType.TECHNICAL_PROVIDER);
            CreateOrganizationHelper.createOrganization(org);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)org), (Object)new OrganizationUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_ORGANIZATION.getId()).build();
        }
    }
    ,
    ORGANIZATION_BLANK_OWNER{

        public String getName() {
            return Messages.Letterhead_owner;
        }

        public void execute() {
            Organization org = new Organization();
            org.getTypes().add(OrganizationType.BLANK_OWNER);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)org), (Object)new OrganizationUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_ORGANIZATION.getId()).build();
        }
    }
    ,
    ORGANIZATION_CORPORATE_CLIENT{

        public String getName() {
            return Messages.Corp_client;
        }

        public void execute() {
            Organization org = new Organization();
            org.getTypes().add(OrganizationType.CORPORATE_CLIENT);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)org), (Object)new OrganizationUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_ORGANIZATION.getId()).build();
        }
    }
    ,
    PERSON_MANAGER{

        public String getName() {
            return Messages.Manager;
        }

        public void execute() {
            Person person = new Person();
            person.getTypes().add(PersonType.MANAGER);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)person), (Object)new PersonUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PERSON.getId()).build();
        }
    }
    ,
    BRANCH{

        public String getName() {
            return Messages.Subdivision;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new Branch())));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_BRANCH.getId()).build();
        }
    }
    ,
    PERSON_PASSENGER{

        public String getName() {
            return Messages.Traveler;
        }

        public void execute() {
            Person person = new Person();
            person.getTypes().add(PersonType.PASSENGER);
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)person), (Object)new PersonUIData()));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PERSON.getId()).build();
        }
    }
    ,
    SALES_POINT{

        public String getName() {
            return Messages.Dimension_sales_point;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new SalesPoint())));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_SALES_POINT.getId()).build();
        }
    }
    ,
    HOLDING{

        public String getName() {
            return Messages.Holding_Company;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new Holding())));
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_HOLDING.getId()).build();
        }
    };


    public String getUid() {
        return "profile-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.PROFILES;
    }

    public double getWeight() {
        return this.ordinal();
    }

    public boolean isAuxiliary() {
        return false;
    }
}

