/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuota;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.Date;

enum StockOrderFactoryTools implements FactoryTool
{
    STOCK_ORDER_TRANSFER{

        public String getName() {
            return Messages.Order_for_the_transfer_of_forms;
        }

        public void execute() {
            StockOrder stockOrder = new StockOrder();
            stockOrder.setType(StockOrderType.TRANSFER);
            stockOrder.setCreated(new Date());
            stockOrder.setRegistrationDate(new Date());
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)stockOrder)));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId());
        }
    }
    ,
    STOCK_ORDER_VENDOR{

        public String getName() {
            return Messages.Order_forms_from_the_supplier;
        }

        public void execute() {
            StockOrder stockOrder = new StockOrder();
            stockOrder.setType(StockOrderType.VENDOR);
            stockOrder.setCreated(new Date());
            stockOrder.setRegistrationDate(new Date());
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)stockOrder)));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId());
        }
    }
    ,
    ETICKET_QUOTA{

        public String getName() {
            return Messages.Electronic_ticket_quota;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new ETicketQuota())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_ETICKET_QUOTA.getId());
        }
    };


    public String getUid() {
        return "stock-order-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.BLANKS;
    }

    public double getWeight() {
        return this.ordinal();
    }

    public boolean isAuxiliary() {
        return false;
    }
}

