/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.UniversalProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHelper;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.uidata.UniversalProductUIData;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.util.MiscUtil;

class UniversalProductTool
implements FactoryTool {
    private final UniversalProductDescriptionData data;

    UniversalProductTool(UniversalProductDescriptionData data) {
        this.data = data;
    }

    public String getUid() {
        return this.data.getReference().getUid();
    }

    public String getName() {
        return this.data.getReference().getCaption();
    }

    public double getWeight() {
        return Double.MAX_VALUE;
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.BOOKINGS;
    }

    public boolean isAuxiliary() {
        return false;
    }

    public AclQuery getACLQuery() {
        return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
    }

    public void execute() {
        CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
            MiscUtil.Pair<UniversalProduct, UniversalProductUIData> prototypeData = UniversalProductFXHelper.getPrototypeData((EntityReference<UniversalProductDescription>)this.data.getReference());
            UniversalProduct product = (UniversalProduct)prototypeData.getFirst();
            UniversalProductUIData productSupplementData = (UniversalProductUIData)prototypeData.getSecond();
            Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            bookingFileSupplementData.getProducts().add(productSupplementData);
        }, false);
    }
}

