/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.async.SabreProfilesSynchronizeOrganizationListAsyncTaskParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SabreProfilesDeleteOrganizationListServerTaskHandler
extends ServerTaskHandler {
    private final List<EntityReference<Organization>> itemsReference;
    private final SearchQuery searchQuery;
    private SabreProfilesPccSettings pccSettings;

    private SabreProfilesDeleteOrganizationListServerTaskHandler(List<EntityReference<Organization>> itemsReference) {
        this.itemsReference = itemsReference;
        this.searchQuery = null;
    }

    private SabreProfilesDeleteOrganizationListServerTaskHandler(SearchQuery searchQuery) {
        this.itemsReference = null;
        this.searchQuery = searchQuery;
    }

    public static void enqueue(List<EntityReference<Organization>> itemsReference) {
        SabreProfilesDeleteOrganizationListServerTaskHandler.enqueue(new SabreProfilesDeleteOrganizationListServerTaskHandler(itemsReference));
    }

    public static void enqueue(SearchQuery searchQuery) {
        SabreProfilesDeleteOrganizationListServerTaskHandler.enqueue(new SabreProfilesDeleteOrganizationListServerTaskHandler(searchQuery));
    }

    private static void enqueue(SabreProfilesDeleteOrganizationListServerTaskHandler handler) {
        Notifications.get().submitTask(() -> {
            try {
                SabreProfilesPccSettings pccSettingsTemp = SabreProfilesSynchronizationUtil.getPccSettingsToDeleteProfiles(Messages.Deleting_org_profiles_Sabre);
                if (pccSettingsTemp == null || TextUtil.isBlank((String)pccSettingsTemp.getPcc())) {
                    Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_pcc_for_sync, (Object[])new Object[0]), SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Org_profiles_not_deleted_no_pcc, (Object[])new Object[0])});
                } else {
                    handler.pccSettings = pccSettingsTemp;
                    FxUtil.submitToFxThread(() -> Notifications.get().enqueueAsyncTask((ServerTaskHandler)handler));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, Messages.Deleting_organization_profiles_in_Saber_Profiles);
    }

    protected String getTitle() {
        return Messages.Deleting_organization_profiles_in_Saber_Profiles;
    }

    protected String getTaskClassName() {
        return "com.gridnine.xtrip.server.fx.async.entityactions.sabreprofiles.SabreProfilesDeleteOrganizationsAsyncTask";
    }

    protected Serializable getTaskParameters() {
        return new SabreProfilesSynchronizeOrganizationListAsyncTaskParameters(this.itemsReference, this.searchQuery, this.pccSettings);
    }

    protected void onCompleted(Object result, List<Message> log) {
        List res = (List)result;
        Message message = SabreProfilesSynchronizationUtil.getSummaryOrganizationsDeleteMessage(res);
        log.add(message);
        Notifications.get().showMessages(new Message[]{message});
        if (this.itemsReference != null) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.itemsReference.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        }
    }
}

