/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.async.SabreProfilesSynchProperties;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SabreProfilesDeletePersonListServerTaskHandler
extends ServerTaskHandler {
    private final List<EntityReference<Person>> itemsReference;
    private final SearchQuery searchQuery;
    private SabreProfilesPccSettings pccSettings;

    private SabreProfilesDeletePersonListServerTaskHandler(List<EntityReference<Person>> itemsReference) {
        this.itemsReference = itemsReference;
        this.searchQuery = null;
    }

    private SabreProfilesDeletePersonListServerTaskHandler(SearchQuery searchQuery) {
        this.itemsReference = null;
        this.searchQuery = searchQuery;
    }

    public static void enqueue(List<EntityReference<Person>> itemsReference) {
        SabreProfilesDeletePersonListServerTaskHandler.enqueue(new SabreProfilesDeletePersonListServerTaskHandler(itemsReference));
    }

    public static void enqueue(SearchQuery searchQuery) {
        SabreProfilesDeletePersonListServerTaskHandler.enqueue(new SabreProfilesDeletePersonListServerTaskHandler(searchQuery));
    }

    private static void enqueue(SabreProfilesDeletePersonListServerTaskHandler handler) {
        Notifications.get().submitTask(() -> {
            try {
                SabreProfilesPccSettings pccSettingsTemp = SabreProfilesSynchronizationUtil.getPccSettingsToDeleteProfiles(Messages.Deleting_traveler_profile_Sabre);
                if (pccSettingsTemp == null || TextUtil.isBlank((String)pccSettingsTemp.getPcc())) {
                    Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_pcc_for_sync, (Object[])new Object[0]), SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Travelers_profile_didnt_deleted_no_pcc, (Object[])new Object[0])});
                } else {
                    handler.pccSettings = pccSettingsTemp;
                    FxUtil.submitToFxThread(() -> Notifications.get().enqueueAsyncTask((ServerTaskHandler)handler));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, Messages.Deleting_traveler_profile_Sabre);
    }

    protected String getTitle() {
        return Messages.Deleting_traveler_profile_Sabre;
    }

    protected String getTaskClassName() {
        return "com.gridnine.xtrip.server.fx.async.entityactions.sabreprofiles.SabreProfilesDeletePersonsAsyncTask";
    }

    protected Serializable getTaskParameters() {
        return new SabreProfilesSynchProperties(this.itemsReference, this.searchQuery, this.pccSettings);
    }

    protected void onCompleted(Object result, List<Message> log) {
        List res = (List)result;
        Message message = SabreProfilesSynchronizationUtil.getSummaryPersonsDeleteMessage(res);
        log.add(message);
        Notifications.get().showMessages(new Message[]{message});
        if (this.itemsReference != null) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.itemsReference.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        }
    }
}

