/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResult;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;

public class SabreProfilesDeletePersonTask
extends ClientTask {
    private final EntityContainer<Person> person;

    public SabreProfilesDeletePersonTask(EntityContainer<Person> person) {
        this.person = person;
    }

    protected String getTitle() {
        return Messages.Deleting_traveler_profile_Sabre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        Message msg;
        ProfilesSynchronizationService syncService = (ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ArrayList<Message> validationErrors = new ArrayList<Message>();
        ValueHolder continueHolder = new ValueHolder((Object)Boolean.TRUE);
        if (this.person == null || this.person.getEntity() == null) {
            msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Profile_is_empty_obj, (Object[])new Object[0]);
            validationErrors.add(msg);
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{msg});
            continueHolder.set((Object)Boolean.FALSE);
        }
        if (Boolean.TRUE.equals(continueHolder.get()) && !this.checkAccess(this.person, validationErrors)) {
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.No_permissions_for_deleting_traveler_profile, (Object[])new Object[0])});
            continueHolder.set((Object)Boolean.FALSE);
        }
        if (Boolean.TRUE.equals(continueHolder.get()) && ((Person)this.person.getEntity()).getSabreProfilesUniqueIDs().isEmpty()) {
            msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Cant_delete_profile_no_profiles, (Object[])new Object[]{this.person.toReference().getCaption()});
            validationErrors.add(msg);
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{msg});
            continueHolder.set((Object)Boolean.FALSE);
        }
        SabreProfilesPccSettings pccSettings = null;
        if (Boolean.TRUE.equals(continueHolder.get())) {
            pccSettings = SabreProfilesSynchronizationUtil.getPccSettingsToDeleteProfile(Messages.Deleting_traveler_profile, ((Person)this.person.getEntity()).getSabreProfilesUniqueIDs(), this.person.toReference().getCaption(), validationErrors, (ValueHolder<Boolean>)continueHolder);
            if (Boolean.TRUE.equals(continueHolder.get()) && (pccSettings == null || TextUtil.isBlank((String)pccSettings.getPcc()))) {
                this.showErrors(validationErrors);
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Org_profile_didnt_deleted, (Object[])new Object[0])});
                continueHolder.set((Object)Boolean.FALSE);
            }
        }
        if (Boolean.TRUE.equals(continueHolder.get())) {
            ArrayList<Message> msgs = new ArrayList<Message>();
            SabreProfilesSynchronizationResult syncResult = null;
            try {
                syncResult = syncService.deletePersonFromSabreProfiles(sic, this.person.toReference(), pccSettings);
            }
            catch (Exception e) {
                try {
                    msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"{0}", (Object[])new Object[]{e.getMessage()}));
                }
                catch (Throwable throwable) {
                    Message summaryMsg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleting_profile_completed_Sabre, (Object[])new Object[]{this.person.toReference().getCaption(), syncResult != null ? syncResult.getType() : ""});
                    msgs.add(summaryMsg);
                    if (syncResult != null) {
                        msgs.addAll(syncResult.getMessages());
                    }
                    this.addMessages(msgs);
                    throw throwable;
                }
                Message summaryMsg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleting_profile_completed_Sabre, (Object[])new Object[]{this.person.toReference().getCaption(), syncResult != null ? syncResult.getType() : ""});
                msgs.add(summaryMsg);
                if (syncResult != null) {
                    msgs.addAll(syncResult.getMessages());
                }
                this.addMessages(msgs);
            }
            Message summaryMsg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleting_profile_completed_Sabre, (Object[])new Object[]{this.person.toReference().getCaption(), syncResult != null ? syncResult.getType() : ""});
            msgs.add(summaryMsg);
            if (syncResult != null) {
                msgs.addAll(syncResult.getMessages());
            }
            this.addMessages(msgs);
        }
        if (Boolean.TRUE.equals(continueHolder.get())) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.person.toReference(), EntityModification.ModificationType.CHANGE)));
        }
    }

    private void showErrors(List<Message> validationErrors) throws Exception {
        this.addMessages(validationErrors);
    }

    private boolean checkAccess(EntityContainer<Person> orgCont, List<Message> messages) throws Exception {
        return true;
    }
}

