/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesUniqueIDSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class SabreProfilesSynchronizationUtil {
    public static RadioBoxWidget<SyncWarningsAction> createWarningsRadioBox() {
        RadioBoxWidget radioBox = new RadioBoxWidget(false);
        radioBox.setItemsSupplier(() -> {
            ArrayList<SyncWarningsAction> result = new ArrayList<SyncWarningsAction>();
            result.add(SyncWarningsAction.SYNC);
            result.add(SyncWarningsAction.DONT_SYNC);
            return result;
        });
        radioBox.valueProperty().set((Object)SyncWarningsAction.DONT_SYNC);
        return radioBox;
    }

    public static Node createWarningsPanel(List<Message> messages, RadioBoxWidget<SyncWarningsAction> options) {
        VBox pane = new VBox();
        RichTextFlow richTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML, MessageHelper.toHtmlString(messages));
        richTextFlow.setMaxWidth(500.0);
        richTextFlow.setPadding(new Insets(20.0));
        pane.getChildren().add((Object)richTextFlow);
        Label message = new Label(Messages.Choose_action);
        pane.getChildren().add((Object)message);
        pane.getChildren().add(options);
        return pane;
    }

    static SabreProfilesPccSettings showPccSettingsDialog(List<SabreProfilesPccSettings> pccSettings, String title) throws Exception {
        ComboBoxWidget<SabreProfilesPccSettings> comboBox = SabreProfilesSynchronizationUtil.createPccsComboBox(pccSettings);
        ValueHolder pccHolder = new ValueHolder();
        CountDownLatch latch = new CountDownLatch(1);
        FxUtil.waitForFxThread(() -> new Dialog().setTitle(title).setMessage(Messages.Choose_ppc).setBody((Node)comboBox).setOnCloseRequest(latch::countDown).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Choose, () -> {
            pccHolder.set(comboBox.valueProperty().get());
            latch.countDown();
        }).showGlobal());
        latch.await();
        return (SabreProfilesPccSettings)pccHolder.get();
    }

    public static RichTextFlow createMessagesPanel(List<Message> messages) {
        RichTextFlow richTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML, MessageHelper.toHtmlString(messages));
        return richTextFlow;
    }

    private static ComboBoxWidget<SabreProfilesPccSettings> createPccsComboBox(List<SabreProfilesPccSettings> pccSettings) {
        ComboBoxWidget comboBox = new ComboBoxWidget(false);
        comboBox.setItemsSupplier(() -> pccSettings);
        comboBox.setSortItems(false);
        comboBox.setConverter((StringConverter)new StringConverter<SabreProfilesPccSettings>(){

            public String toString(SabreProfilesPccSettings settings) {
                return settings.getPcc() + (TextUtil.nonBlank((String)settings.getDescription()) ? " (" + settings.getDescription() + ")" : "");
            }

            public SabreProfilesPccSettings fromString(String string) {
                return null;
            }
        });
        comboBox.valueProperty().set((Object)pccSettings.get(0));
        return comboBox;
    }

    public static List<String> getPccSettingsFromProfilesUniqueIDs(EntityContainer<Person> personCont) {
        Person person = (Person)personCont.getEntity();
        if (!person.getSabreProfilesUniqueIDs().isEmpty()) {
            return person.getSabreProfilesUniqueIDs().stream().filter(Objects::nonNull).map(idSetting -> idSetting.getPcc()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static SabreProfilesPccSettings getPccSettings(String title, List<Message> validationErrors, ValueHolder<Boolean> continueHolder, List<SabreProfilesPccSettings> predefinedPccsSettings) throws Exception {
        List filteredPccs;
        SabreProfilesPccSettings res = new SabreProfilesPccSettings();
        List pccsFromUser = Prefetched.getData().getSabreProfilesSettings().getCurrentUserPccSettings();
        ArrayList allowedPccSettings = new ArrayList(pccsFromUser);
        ArrayList allowedPccs = new ArrayList(ProfileSynchronizationUtil.getPccValues(allowedPccSettings));
        if (allowedPccs.isEmpty()) {
            allowedPccSettings.clear();
            allowedPccSettings.addAll(Prefetched.getData().getSabreProfilesSettings().getDefaultPccSettings());
            allowedPccs.addAll(ProfileSynchronizationUtil.getPccValues(allowedPccSettings));
        }
        if ((filteredPccs = ProfileSynchronizationUtil.filterPccsSettings(predefinedPccsSettings, allowedPccSettings)).isEmpty() && !allowedPccs.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SabreProfilesSynchronizationToolHandler_pccFromProfileNotCompatible, (Object[])new Object[0]));
        } else if (filteredPccs.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_ppc_in_agent_profile, (Object[])new Object[0]));
        } else if (allowedPccs.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SabreProfilesSynchronizationToolHandler_pccNotSet, (Object[])new Object[0]));
        } else if (filteredPccs.size() == 1) {
            res = (SabreProfilesPccSettings)filteredPccs.get(0);
        } else {
            SabreProfilesPccSettings selectedPcc = SabreProfilesSynchronizationUtil.showPccSettingsDialog(filteredPccs, title);
            if (selectedPcc != null) {
                res = selectedPcc;
            } else {
                continueHolder.set((Object)Boolean.FALSE);
                return null;
            }
        }
        if (res.getPcc() != null) {
            res.setPcc(res.getPcc().toUpperCase());
        }
        return res;
    }

    public static SabreProfilesPccSettings getUniqueIDsPccSettings(String title, List<Message> validationErrors, ValueHolder<Boolean> continueHolder, List<String> PccsSettings) throws Exception {
        ArrayList allowedPccs = new ArrayList(Prefetched.getData().getSabreProfilesSettings().getDefaultPccSettings());
        List filteredPccs = ProfileSynchronizationUtil.filterIDsPccsSettings(PccsSettings, allowedPccs);
        if (allowedPccs.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SabreProfilesUpdate_DefaultPccSettingsIsEmpty, (Object[])new Object[0]));
        } else if (filteredPccs.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SabreProfilesUpdate_FilteredPccSettingsIsEmpty, (Object[])new Object[0]));
        } else {
            if (filteredPccs.size() == 1) {
                return (SabreProfilesPccSettings)filteredPccs.get(0);
            }
            SabreProfilesPccSettings selectedPcc = SabreProfilesSynchronizationUtil.showPccSettingsDialog(filteredPccs, title);
            if (selectedPcc != null) {
                return selectedPcc;
            }
        }
        continueHolder.set((Object)Boolean.FALSE);
        return null;
    }

    public static SabreProfilesPccSettings getPccSettings(String title) throws Exception {
        SabreProfilesPccSettings res = new SabreProfilesPccSettings();
        List userSettings = Prefetched.getData().getSabreProfilesSettings().getCurrentUserPccSettings();
        if (userSettings.size() == 1) {
            res = (SabreProfilesPccSettings)userSettings.get(0);
        } else if (userSettings.size() > 1 && (res = SabreProfilesSynchronizationUtil.showPccSettingsDialog(userSettings, title)) == null) {
            return null;
        }
        if (res == null || TextUtil.isBlank((String)res.getPcc())) {
            List globalSettings = Prefetched.getData().getSabreProfilesSettings().getDefaultPccSettings();
            if (globalSettings.size() == 1) {
                res = (SabreProfilesPccSettings)globalSettings.get(0);
            } else if (globalSettings.size() > 1 && (res = SabreProfilesSynchronizationUtil.showPccSettingsDialog(globalSettings, title)) == null) {
                return null;
            }
        }
        if (res != null && res.getPcc() != null) {
            res.setPcc(res.getPcc().toUpperCase());
        }
        return res;
    }

    public static List<SabreProfilesPccSettings> getPccsFromSettings() {
        List pccsFromSettings = Prefetched.getData().getSabreProfilesSettings().getCurrentUserPccSettings();
        if (pccsFromSettings.isEmpty()) {
            pccsFromSettings.addAll(Prefetched.getData().getSabreProfilesSettings().getDefaultPccSettings());
        }
        return pccsFromSettings;
    }

    static List<SabreProfilesPccSettings> getUniquePccSettings(Collection<List<SabreProfilesPccSettings>> settingsList) {
        return new ArrayList<SabreProfilesPccSettings>(settingsList.stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).distinct().filter(settings -> TextUtil.nonBlank((String)settings.getPcc())).collect(Collectors.toMap(settings -> settings.getPcc().trim().toUpperCase(), Function.identity(), (first, second) -> first, LinkedHashMap::new)).values());
    }

    public static void showResults(String title, String headerMessage, List<Message> messages) throws Exception {
        FxUtil.waitForFxThread(() -> new Dialog().setTitle(title).setMessage(headerMessage).setBody((Node)SabreProfilesSynchronizationUtil.createMessagesPanel(messages)).addButton(DialogButtonStyle.ACCEPT_REGULAR).showGlobal());
    }

    public static void showErrors(String title, String headerMessage, List<Message> validationErrors) throws Exception {
        FxUtil.waitForFxThread(() -> new Dialog().setTitle(title).setMessage(headerMessage).setBody((Node)SabreProfilesSynchronizationUtil.createMessagesPanel(validationErrors)).addButton(DialogButtonStyle.ACCEPT_REGULAR).showGlobal());
    }

    public static void showWarnings(String title, String headerMessage, List<Message> validationWarnings, ValueHolder<Boolean> continueHolder) throws Exception {
        RadioBoxWidget<SyncWarningsAction> options = SabreProfilesSynchronizationUtil.createWarningsRadioBox();
        CountDownLatch latch = new CountDownLatch(1);
        FxUtil.waitForFxThread(() -> new Dialog().setTitle(title).setMessage(headerMessage).setBody(SabreProfilesSynchronizationUtil.createWarningsPanel(validationWarnings, options)).setOnCloseRequest(() -> {
            latch.countDown();
            continueHolder.set((Object)Boolean.FALSE);
        }).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
            if (options.valueProperty().get() == SyncWarningsAction.DONT_SYNC) {
                continueHolder.set((Object)Boolean.FALSE);
            } else {
                continueHolder.set((Object)Boolean.TRUE);
            }
            latch.countDown();
        }).showGlobal());
        latch.await();
    }

    public static void showConfirmation(String title, String headerMessage, Runnable acceptCallback, Runnable declineCallback) {
        new Dialog().setTitle(title).setMessage(headerMessage).setOnCloseRequest(() -> {
            if (declineCallback != null) {
                declineCallback.run();
            }
        }).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> acceptCallback.run()).addButton(DialogButtonStyle.DECLINE, () -> {
            if (declineCallback != null) {
                declineCallback.run();
            }
        }).showGlobal();
    }

    public static SabreProfilesPccSettings getPccSettingsToDeleteProfiles(String title) throws Exception {
        SabreProfilesPccSettings res = null;
        List<SabreProfilesPccSettings> pccsFromSettings = SabreProfilesSynchronizationUtil.getPccsFromSettings();
        if (!pccsFromSettings.isEmpty()) {
            res = pccsFromSettings.size() > 1 ? SabreProfilesSynchronizationUtil.showPccSettingsDialog(pccsFromSettings, title) : pccsFromSettings.get(0);
        }
        return res;
    }

    public static SabreProfilesPccSettings getPccSettingsToDeleteProfile(String title, List<SabreProfilesUniqueIDSettings> idsFromProfile, String profileCaption, List<Message> validationErrors, ValueHolder<Boolean> continueHolder) throws Exception {
        SabreProfilesPccSettings res = null;
        List pccsFromProfile = idsFromProfile.stream().filter(s -> !TextUtil.isBlank((String)s.getPcc())).map(a -> a.getPcc().toUpperCase()).collect(Collectors.toList());
        List<SabreProfilesPccSettings> pccsFromSettings = SabreProfilesSynchronizationUtil.getPccsFromSettings();
        if (pccsFromSettings.isEmpty()) {
            validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_ppc_in_agent_profile, (Object[])new Object[0]));
        } else {
            ArrayList<SabreProfilesPccSettings> commonPccSettings = new ArrayList<SabreProfilesPccSettings>();
            for (SabreProfilesPccSettings s2 : pccsFromSettings) {
                if (!pccsFromProfile.contains(s2.getPcc())) continue;
                res = s2;
                commonPccSettings.add(s2);
            }
            if (commonPccSettings.isEmpty()) {
                validationErrors.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Cant_delete_profile, (Object[])new Object[]{profileCaption}));
            } else if (commonPccSettings.size() > 1) {
                SabreProfilesPccSettings selectedPcc = SabreProfilesSynchronizationUtil.showPccSettingsDialog(commonPccSettings, title);
                if (selectedPcc != null) {
                    res = selectedPcc;
                } else {
                    continueHolder.set((Object)Boolean.FALSE);
                }
            }
        }
        return res;
    }

    public static Message getSummaryOrganizationsSyncMessage(List<Integer> res) {
        if (res.size() == 4) {
            return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_org_Sabre_completed, (Object[])new Object[]{res.get(0), res.get(1), res.get(2), res.get(3)});
        }
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_completed2, (Object[])new Object[0]);
    }

    public static Message getSummaryPersonsSyncMessage(List<Integer> res) {
        if (res.size() == 4) {
            return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_travelers_Sabre_completed, (Object[])new Object[]{res.get(0), res.get(1), res.get(2), res.get(3)});
        }
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_completed2, (Object[])new Object[0]);
    }

    public static Message getSummaryPersonsUpdateMessage(List<Integer> res) {
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Update_travelers_Sabre_completed, (Object[])new Object[]{res.get(0), res.get(1), res.get(2), res.get(3)});
    }

    public static Message getSummaryOrganizationsDeleteMessage(List<Integer> res) {
        if (res.size() == 4) {
            return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleting_org_Sabre_completed, (Object[])new Object[]{res.get(0), res.get(1), res.get(2), res.get(3)});
        }
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Delete_completed, (Object[])new Object[0]);
    }

    public static Message getSummaryPersonsDeleteMessage(List<Integer> res) {
        if (res.size() == 4) {
            return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleting_travelers_Sabre_completed, (Object[])new Object[]{res.get(0), res.get(1), res.get(2), res.get(3)});
        }
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Delete_completed, (Object[])new Object[0]);
    }

    public static Message getSummaryPersonsSyncGTMessage(List<Integer> res) {
        if (res.size() == 4) {
            return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_travelers_GetThere_completed, (Object[])new Object[]{res.get(0), res.get(1), res.get(2), res.get(3)});
        }
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_completed2, (Object[])new Object[0]);
    }

    public static interface SyncSettingExecutable {
        public void execute(boolean var1);
    }

    public static enum SyncWarningsAction {
        SYNC{

            public String toString() {
                return Messages.Synhronize;
            }
        }
        ,
        DONT_SYNC{

            public String toString() {
                return Messages.Cancel_synhronization;
            }
        };

    }
}

