/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesValidationResult;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;

public class SabreProfilesSynchronizeOrganizationTask
extends ClientTask {
    private final EntityContainer<Organization> orgCont;

    public SabreProfilesSynchronizeOrganizationTask(EntityContainer<Organization> orgCont) {
        this.orgCont = orgCont;
    }

    protected String getTitle() {
        return Messages.Org_synhronization_Sabre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        ProfilesSynchronizationService syncService = (ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class);
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ArrayList<Message> validationErrors = new ArrayList<Message>();
        ValueHolder continueHolder = new ValueHolder((Object)Boolean.TRUE);
        if (this.orgCont == null || this.orgCont.getEntity() == null) {
            Message msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Profile_is_empty_obj, (Object[])new Object[0]);
            validationErrors.add(msg);
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{msg});
            continueHolder.set((Object)Boolean.FALSE);
            return;
        }
        if (Boolean.TRUE.equals(continueHolder.get()) && !this.checkAccess(this.orgCont, validationErrors)) {
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.No_permissions_for_synhronization_org_profile, (Object[])new Object[0])});
            continueHolder.set((Object)Boolean.FALSE);
        }
        SabreProfilesValidationResult validationResult = null;
        boolean isSuccessValidation = false;
        if (Boolean.TRUE.equals(continueHolder.get())) {
            validationResult = syncService.validateOrganizationSabreProfiles(sic, this.orgCont.toReference());
            isSuccessValidation = !validationResult.isError();
            validationErrors.addAll(validationResult.getMessages());
        }
        if (!isSuccessValidation) {
            this.showErrors(validationErrors);
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Not_synhronized_errors_org_profile, (Object[])new Object[0])});
            continueHolder.set((Object)Boolean.FALSE);
            this.orgCont.getVersionInfo().setDataSource("fx-sabre-sync");
            entityService.save(sic, this.orgCont, null, false);
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.orgCont.toReference(), EntityModification.ModificationType.CHANGE)));
        } else if (validationErrors.size() > 0) {
            this.showWarnings(validationErrors, (ValueHolder<Boolean>)continueHolder);
            if (Boolean.FALSE.equals(continueHolder.get())) {
                this.orgCont.getVersionInfo().setDataSource("fx-sabre-sync");
                entityService.save(sic, this.orgCont, null, false);
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.orgCont.toReference(), EntityModification.ModificationType.CHANGE)));
            }
        }
        SabreProfilesPccSettings pccSettings = null;
        if (Boolean.TRUE.equals(continueHolder.get())) {
            pccSettings = SabreProfilesSynchronizationUtil.getPccSettings(Messages.Organization_synhronization_Sabre, validationErrors, (ValueHolder<Boolean>)continueHolder, syncService.getPccSettingsForOrganization(sic, this.orgCont.toReference()));
            if (Boolean.TRUE.equals(continueHolder.get()) && (pccSettings == null || TextUtil.isBlank((String)pccSettings.getPcc()))) {
                this.showErrors(validationErrors);
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Org_profile_didnt_synhronized_no_agent_pcc, (Object[])new Object[0])});
                continueHolder.set((Object)Boolean.FALSE);
            }
        }
        if (Boolean.TRUE.equals(continueHolder.get())) {
            ArrayList<Message> msgs = new ArrayList<Message>();
            SabreProfilesSynchronizationResult syncResult = null;
            try {
                syncResult = syncService.sendOrganizationToSabreProfiles(sic, this.orgCont.toReference(), pccSettings, validationResult);
            }
            catch (Exception e) {
                try {
                    msgs.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"{0}", (Object[])new Object[]{e.getMessage()}));
                }
                catch (Throwable throwable) {
                    Message summaryMsg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_for_profile_N_complete, (Object[])new Object[]{this.orgCont.toReference().getCaption(), syncResult != null ? syncResult.getType() : ""});
                    msgs.add(summaryMsg);
                    if (syncResult != null) {
                        msgs.addAll(syncResult.getMessages());
                    }
                    this.addMessages(msgs);
                    throw throwable;
                }
                Message summaryMsg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_for_profile_N_complete, (Object[])new Object[]{this.orgCont.toReference().getCaption(), syncResult != null ? syncResult.getType() : ""});
                msgs.add(summaryMsg);
                if (syncResult != null) {
                    msgs.addAll(syncResult.getMessages());
                }
                this.addMessages(msgs);
            }
            Message summaryMsg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Synhronization_for_profile_N_complete, (Object[])new Object[]{this.orgCont.toReference().getCaption(), syncResult != null ? syncResult.getType() : ""});
            msgs.add(summaryMsg);
            if (syncResult != null) {
                msgs.addAll(syncResult.getMessages());
            }
            this.addMessages(msgs);
        }
        if (Boolean.TRUE.equals(continueHolder.get())) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.orgCont.toReference(), EntityModification.ModificationType.CHANGE)));
        }
    }

    private boolean checkAccess(EntityContainer<Organization> orgCont, List<Message> messages) throws Exception {
        return true;
    }

    private void showErrors(List<Message> validationErrors) throws Exception {
        this.addMessages(validationErrors);
    }

    private void showWarnings(List<Message> validationWarnings, ValueHolder<Boolean> continueHolder) throws Exception {
        SabreProfilesSynchronizationUtil.showWarnings(Messages.Org_synhronization_Sabre2, Messages.Validation_error_profile, validationWarnings, continueHolder);
    }
}

