/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileValidationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResultType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesValidationResult;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SabreProfilesSynchronizePersonListTask
extends ClientTask {
    private final List<EntityReference<Person>> itemsReference;
    private final SearchQuery searchQuery;
    private static final int PREPARING_PROGRESS = 50;
    private static final int SYNCHRONIZING_PROGRESS = 50;

    public SabreProfilesSynchronizePersonListTask(List<EntityReference<Person>> persons) {
        this.itemsReference = persons;
        this.searchQuery = null;
    }

    public SabreProfilesSynchronizePersonListTask(SearchQuery searchQuery) {
        this.itemsReference = null;
        this.searchQuery = searchQuery;
    }

    protected String getTitle() {
        return Messages.Travelers_synhronization_Sabre;
    }

    protected void execute() throws Exception {
        int numTotalSelected;
        int count;
        ProfilesSynchronizationService syncService = (ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class);
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ArrayList<Message> validationErrors = new ArrayList<Message>();
        HashMap<EntityContainer, SabreProfilesValidationResult> travellerContainers = new HashMap<EntityContainer, SabreProfilesValidationResult>();
        if (this.itemsReference != null) {
            count = 1;
            numTotalSelected = this.itemsReference.size();
            for (EntityReference<Person> personReference : this.itemsReference) {
                EntityContainer personContainer;
                if (personReference != null && (personContainer = entityService.load(sic, personReference)) != null) {
                    if (((Person)personContainer.getEntity()).getTypes().contains(PersonType.PASSENGER)) {
                        SabreProfilesValidationResult validationResult = syncService.validatePersonSabreProfiles(sic, personReference);
                        if (!validationResult.isError()) {
                            travellerContainers.put(personContainer, validationResult);
                        } else {
                            this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.valSPMsg7, (Object[])new Object[]{personReference.getCaption()})});
                            this.addMessages(validationResult.getMessages());
                            personContainer.getVersionInfo().setDataSource("fx-sabre-sync");
                            entityService.save(sic, personContainer, null, false);
                        }
                    } else {
                        this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.Person_isnt_traveler, (Object[])new Object[]{personReference.getCaption()})});
                    }
                }
                int progress = 50 * count / this.itemsReference.size();
                this.setProgress((byte)progress, "Prepared for synchronization: " + personReference);
                ++count;
            }
        } else {
            this.searchQuery.setOffset(0);
            this.searchQuery.setResultMode(ResultMode.DATA_ONLY);
            this.searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
            this.searchQuery.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER.name()));
            List personUids = SabreProfilesSynchronizePersonListTask.searchUids(this.searchQuery, PersonIndex.class).stream().map(Identity::getUid).collect(Collectors.toList());
            int i = 0;
            int count2 = 1;
            numTotalSelected = personUids.size();
            while (i < personUids.size()) {
                int toIndex = i + 1000 > personUids.size() ? personUids.size() : i + 1000;
                this.searchQuery.getCriteria().getCriterions().add(SearchCriterion.in((String)"uid", (Object[])personUids.subList(i, toIndex).toArray()));
                List travellerIndexes = entityService.search(sic, PersonIndex.class, this.searchQuery);
                for (PersonIndex travellerIndex : travellerIndexes) {
                    EntityContainer travellerContainer = entityService.load(sic, travellerIndex.getSource());
                    if (travellerContainer != null) {
                        SabreProfilesValidationResult validationResult = syncService.validatePersonSabreProfiles(sic, travellerIndex.getSource());
                        if (!validationResult.isError()) {
                            travellerContainers.put(travellerContainer, validationResult);
                        } else {
                            this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.valSPMsg7, (Object[])new Object[]{travellerIndex.getSource().getCaption()})});
                            this.addMessages(validationResult.getMessages());
                            travellerContainer.getVersionInfo().setDataSource("fx-sabre-sync");
                            entityService.save(sic, travellerContainer, null, false);
                        }
                    }
                    int progress = 50 * count2 / travellerIndexes.size();
                    this.setProgress((byte)progress, "Prepared for synchronization: " + travellerIndex.getSource());
                    ++count2;
                }
            }
        }
        if (travellerContainers.isEmpty()) {
            this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.SabreProfilesSynchronizationToolHandler_personNotFound, (Object[])new Object[0])});
            return;
        }
        count = 1;
        int numNotValidated = numTotalSelected - travellerContainers.size();
        int numSyncSuccess = 0;
        int numSyncFailed = 0;
        List<SabreProfilesPccSettings> allowedPccSettings = SabreProfilesSynchronizationUtil.getPccsFromSettings();
        HashMap<EntityContainer, MiscUtil.Pair> personsWithPccs = new HashMap<EntityContainer, MiscUtil.Pair>();
        for (Map.Entry entry : travellerContainers.entrySet()) {
            EntityContainer travellerContainer = (EntityContainer)entry.getKey();
            SabreProfilesValidationResult validationResult = (SabreProfilesValidationResult)entry.getValue();
            if (!this.checkAccess((EntityContainer<Person>)travellerContainer, validationErrors)) continue;
            List predefinedPccSettings = syncService.getPccSettingsForPerson(sic, travellerContainer.toReference());
            List synchOrgSettings = ProfileValidationUtil.getOrganizationsForPerson((Person)((Person)travellerContainer.getEntity())).stream().map(org -> {
                try {
                    return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), org);
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)("error has occurred: " + e.getMessage()), (Throwable)e, (Object[])new Object[0]);
                }
            }).filter(Objects::nonNull).filter(ctr -> !((Organization)ctr.getEntity()).isNotSynchronizeWithSabreProfile()).flatMap(ctr -> ((Organization)ctr.getEntity()).getSabreProfilesPccSettings().isEmpty() ? predefinedPccSettings.stream() : ((Organization)ctr.getEntity()).getSabreProfilesPccSettings().stream()).collect(Collectors.toList());
            allowedPccSettings.removeIf(item -> synchOrgSettings.stream().noneMatch(orgSetting -> TextUtil.equals((String)item.getPcc(), (String)orgSetting.getPcc(), (boolean)false)));
            List filteredPccSettings = ProfileSynchronizationUtil.filterPccsSettings((List)predefinedPccSettings, allowedPccSettings);
            personsWithPccs.put(travellerContainer, new MiscUtil.Pair((Object)filteredPccSettings, (Object)validationResult));
        }
        List<SabreProfilesPccSettings> commonPccs = SabreProfilesSynchronizationUtil.getUniquePccSettings(personsWithPccs.values().stream().map(MiscUtil.Pair::getFirst).collect(Collectors.toList()));
        if (commonPccs.size() == 0) {
            this.addMessages(new Message[]{MessageHelper.createErrorMessage((String)Messages.SabreProfilesSynchronizationToolHandler_selectedProfilesDoesNotHaveCommonPccs, (Object[])new Object[0])});
        } else {
            SabreProfilesPccSettings pcc = commonPccs.size() == 1 ? commonPccs.get(0) : SabreProfilesSynchronizationUtil.showPccSettingsDialog(commonPccs, Messages.Travelers_synhronization_Sabre);
            for (Map.Entry entry : personsWithPccs.entrySet()) {
                EntityContainer travellerContainer = (EntityContainer)entry.getKey();
                SabreProfilesValidationResult validationResult = (SabreProfilesValidationResult)((MiscUtil.Pair)entry.getValue()).getSecond();
                if (this.checkAccess((EntityContainer<Person>)travellerContainer, validationErrors)) {
                    boolean res = pcc != null && SabreProfilesSynchronizePersonListTask.synchronizePersonToSabreProfiles((EntityContainer<Person>)travellerContainer, pcc, validationResult, validationErrors);
                    this.addMessages(validationErrors);
                    validationErrors.clear();
                    if (res) {
                        ++numSyncSuccess;
                    } else {
                        ++numSyncFailed;
                    }
                }
                int progress = 50 + 50 * count / travellerContainers.size();
                this.setProgress((byte)progress, String.format(Messages.SabreProfilesSynchronizationToolHandler_personAdded, travellerContainer.getEntity()));
                ++count;
            }
            this.addMessages(new Message[]{SabreProfilesSynchronizationUtil.getSummaryPersonsSyncMessage(Arrays.asList(numTotalSelected, numSyncSuccess, numNotValidated, numSyncFailed))});
            if (this.itemsReference != null) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.itemsReference.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            }
        }
        this.setProgress((byte)100, Messages.SabreProfilesSynchronizationToolHandler_syncComplete);
    }

    public static boolean synchronizePersonToSabreProfiles(EntityContainer<Person> perCont, SabreProfilesPccSettings pccSettings, SabreProfilesValidationResult validationResult, List<Message> msgs) {
        if (perCont == null) {
            return false;
        }
        boolean res = true;
        String perCaption = perCont.toReference().getCaption();
        try {
            RpcServiceManager rpcServiceManager = RpcServiceManager.get();
            ServiceInvocationContext serviceInvocationContext = ServiceInvocationContext.get();
            EntityReference perRef = perCont.toReference();
            List orgRefs = ProfileHelper.getOrganizationForPerson((Person)((Person)perCont.getEntity()));
            SabreProfilesSynchronizationResult currentRes = ((ModelService)rpcServiceManager.getService(ModelService.class)).sendTravelerToSabreProfiles(serviceInvocationContext, perRef, orgRefs.size() > 0 ? (EntityReference)orgRefs.get(0) : null, orgRefs, pccSettings, validationResult);
            msgs.add(MessageHelper.createMessage((String)Messages.valSPMsg2, (Object[])new Object[]{perCaption, currentRes.getType()}));
            if (currentRes.getType() == SabreProfilesSynchronizationResultType.ERROR) {
                res = false;
            }
            msgs.addAll(currentRes.getMessages());
        }
        catch (Exception e) {
            res = false;
            msgs.add(MessageHelper.createMessage((String)Messages.valSPMsg2, (Object[])new Object[]{perCaption, "ERROR"}));
            msgs.add(MessageHelper.createErrorMessage((String)"{0}", (Object[])new Object[]{e.getMessage()}));
        }
        return res;
    }

    private boolean checkAccess(EntityContainer<Person> perCont, List<Message> messages) throws Exception {
        return true;
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> List<I> searchUids(SearchQuery query, Class<I> indexType) throws Exception {
        SearchQuery uidsQuery = new SearchQuery();
        uidsQuery.getCriteria().getCriterions().addAll(query.getCriteria().getCriterions());
        uidsQuery.getCriteria().getRestrictions().addAll(query.getCriteria().getRestrictions());
        uidsQuery.getPreferredProperties().add("uid");
        uidsQuery.getCriteria().setFreeTextPattern(query.getCriteria().getFreeTextPattern());
        uidsQuery.getCriteria().getOrders().putAll(query.getCriteria().getOrders());
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), indexType, uidsQuery);
    }
}

