/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.PlainGroupsWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerAdditionalPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerDocumentPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PersonTitle;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;

public class BookingFileSpaceHelper {
    public static BookingFileSpace lookupBookingFileSpace(Node node) {
        RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)node);
        return rootEntityPane == null ? null : (BookingFileSpace)rootEntityPane.getEditor();
    }

    public static EntityContainer<BookingFile> lookupBookingFileContainer(Node node) {
        RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)node);
        if (rootEntityPane == null || rootEntityPane.getData() == null) {
            return null;
        }
        return rootEntityPane.getData().getContainer();
    }

    public static void cleanupReservations(BookingFileSpaceVM bookingFileVM) {
        Set reservationUids = bookingFileVM.getProductsFull().getContent().stream().map(item -> ProductFXHandler.forProductClass(((BaseProductVM)item).getProductType()).getRecordLocator((BaseProductVM)item)).collect(Collectors.toSet());
        Iterator reservationIterator = bookingFileVM.getReservationsFull().getContent().iterator();
        while (reservationIterator.hasNext()) {
            BookingFileReservationsFullContainerVM reservation = (BookingFileReservationsFullContainerVM)reservationIterator.next();
            if (reservationUids.contains(reservation.getUid())) continue;
            reservationIterator.remove();
        }
    }

    public static CustomContextMenu getAddTravellerContextMenu(Node view, Consumer<Traveller> consumer) {
        CustomContextMenu cm = new CustomContextMenu();
        CustomMenuItem newPassengerMenuItem = new CustomMenuItem(Messages.Add_new_traveler);
        newPassengerMenuItem.setOnAction(event -> BookingFileSpaceHelper.showAddTravellerDialog(view, consumer));
        CustomMenuItem newPassengerFromProfileMenuItem = new CustomMenuItem(Messages.Select_traveler);
        newPassengerFromProfileMenuItem.setOnAction(event -> BookingFileSpaceHelper.showAddTravellerFromProfileDialog(view, consumer));
        cm.getItems().addAll((Object[])new MenuItem[]{newPassengerMenuItem, newPassengerFromProfileMenuItem});
        return cm;
    }

    private static void showAddTravellerDialog(Node view, Consumer<Traveller> consumer) {
        BookingFileTravelerAdditionalPanel travellerPanel = new BookingFileTravelerAdditionalPanel(false);
        travellerPanel.getTravellerCell().setHidden(true);
        travellerPanel.getProfileCell().setHidden(true);
        Traveller newTraveller = new Traveller();
        travellerPanel.getTravellerNode().setValue((Object)newTraveller);
        Dialog dialog = new Dialog();
        dialog.setAutoClose(false).setTitle(Messages.Adding_new_traveler).setBody((Node)travellerPanel).setExpandToParent(false).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Dialog_save, () -> {
            if (TextUtil.isBlank((String)travellerPanel.getNameNode().getValue())) {
                Dialog.info((String)Messages.Field_name_empty);
            } else {
                BookingFileSpaceHelper.saveTravellerAdditionalPanel(travellerPanel, view, consumer);
                dialog.close();
            }
        }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).setOnCloseRequest(() -> ((Dialog)dialog).close());
        dialog.show(view);
    }

    private static void showAddTravellerFromProfileDialog(Node view, Consumer<Traveller> consumer) {
        BookingFileSpace bfSpace = BookingFileSpaceHelper.lookupBookingFileSpace(view);
        EntityBoxWidget clientWidget = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)bfSpace.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode();
        EntityReference clientRef = clientWidget.getValue();
        IndexListPane<Person, PersonIndex> listPane = new IndexListPane<Person, PersonIndex>(RootEntityPane.lookup((Node)view).getMutex(), ControllerInterceptorsHelper.getPassengers((EntityReference<Organization>)clientRef, (EntityReference<Holding>)((EntityReference)clientWidget.getProperties().get((Object)"holding"))), SelectionMode.SINGLE, false){

            protected void newConfigurationPopulated() {
                this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource())));
            }
        };
        new Dialog().setTitle(Messages.Select_traveler_from_profile).setBody((Node)listPane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Select, () -> BookingFileSpaceHelper.lambda$showAddTravellerFromProfileDialog$4((IndexListPane)listPane, view, consumer), (BooleanExpression)listPane.selectionPresentProperty()).show(view);
    }

    private static void saveTravellerAdditionalPanel(BookingFileTravelerAdditionalPanel travellerPanel, Node view, Consumer<Traveller> consumer) {
        Traveller traveller = new Traveller();
        traveller.setName(travellerPanel.getNameNode().getValue());
        traveller.setCyrillicName(travellerPanel.getCyrillicNameNode().getValue());
        traveller.setGender((Gender)travellerPanel.getGenderNode().getValue());
        traveller.setTitle((PersonTitle)travellerPanel.getTitleNode().getValue());
        traveller.setBirthday(DateUtils.asDate((LocalDate)travellerPanel.getBirthdayNode().getValue()));
        traveller.setPassenger(travellerPanel.getProfileNode().getValue());
        BookingFileTravelerPanelVM vm = new BookingFileTravelerPanelVM();
        vm.setUid(traveller.getUid());
        vm.getGeneralParameters().setTraveller(traveller);
        vm.getGeneralParameters().setName(traveller.getName());
        vm.getGeneralParameters().setCyrillicName(traveller.getCyrillicName());
        vm.getGeneralParameters().setGender(traveller.getGender());
        vm.getGeneralParameters().setTitle(traveller.getTitle());
        vm.getGeneralParameters().setBirthday(DateUtils.asLocalDate((Date)traveller.getBirthday()));
        vm.getGeneralParameters().setProfile(traveller.getPassenger());
        BookingFileTravelerPanel travellerFullNode = new BookingFileTravelerPanel(false);
        travellerFullNode.getProperties().put((Object)"model-uid", (Object)traveller.getUid());
        new BookingFileTravelerPanelController(travellerFullNode, false).readData(vm);
        BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace(view);
        ((PlainGroupsWidget)((BookingFileTravelersPanel)bookingFileSpace.getTravelersTile().getFullNode()).getContent()).getViews().add((Object)travellerFullNode);
        consumer.accept(traveller);
    }

    private static void saveTravellerFromProfile(EntityReference<Person> reference, Node view, Consumer<Traveller> consumer) {
        BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace(view);
        ObservableList travelersFullPanelList = ((PlainGroupsWidget)((BookingFileTravelersPanel)bookingFileSpace.getTravelersTile().getFullNode()).getContent()).getViews();
        Optional<BookingFileTravelerPanel> existingTravellerPanelOptional = travelersFullPanelList.stream().filter(travellerPanel -> reference.equals((Object)((BookingFileTravelerGeneralPanel)travellerPanel.getGeneralParametersCard().getContent()).getProfileNode().getValue())).findFirst();
        if (existingTravellerPanelOptional.isPresent()) {
            Traveller existingTraveller = (Traveller)((BookingFileTravelerGeneralPanel)existingTravellerPanelOptional.get().getGeneralParametersCard().getContent()).getTravellerNode().getValue();
            consumer.accept(existingTraveller);
        } else {
            BookingFileSpaceHelper.addAndSelectNewTraveller(reference, view, consumer);
        }
    }

    private static void addAndSelectNewTraveller(EntityReference<Person> reference, Node view, Consumer<Traveller> consumer) {
        Notifications.get().submitTask(() -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            EntityContainer person = entityService.load(sic, reference);
            if (person != null) {
                FxUtil.waitForFxThread(() -> {
                    Person personEntity = (Person)person.getEntity();
                    Traveller traveller = new Traveller();
                    PersonalLocalizableNameFormatter formatter = new PersonalLocalizableNameFormatter("L F M");
                    String name = formatter.format((PersonalLocalizableName)personEntity, LocaleManager.get().getCurrentLocale(), false);
                    if (name == null) {
                        name = formatter.formatAnyLocale((PersonalLocalizableName)personEntity);
                    }
                    traveller.setName(name);
                    traveller.setBirthday(personEntity.getBirthday());
                    traveller.setGender(personEntity.getGender());
                    traveller.setTitle(personEntity.getTitle());
                    traveller.setPassenger(reference);
                    List passports = personEntity.getPassports();
                    if (!passports.isEmpty()) {
                        traveller.setPassport((Passport)XCloneHelper.clone((XCloneable)((XCloneable)passports.get(0))));
                    }
                    BookingFileTravelerPanelVM vm = new BookingFileTravelerPanelVM();
                    vm.setUid(traveller.getUid());
                    BookingFileTravelerGeneralPanelVM generalParameters = vm.getGeneralParameters();
                    generalParameters.setTraveller(traveller);
                    generalParameters.setName(traveller.getName());
                    generalParameters.setCyrillicName(traveller.getCyrillicName());
                    generalParameters.setGender(traveller.getGender());
                    generalParameters.setTitle(traveller.getTitle());
                    generalParameters.setBirthday(DateUtils.asLocalDate((Date)traveller.getBirthday()));
                    generalParameters.setProfile(traveller.getPassenger());
                    Passport travellerPassport = traveller.getPassport();
                    if (travellerPassport != null) {
                        BookingFileTravelerDocumentPanelVM documents = vm.getDocuments();
                        documents.setUid(traveller.getPassport().getUid());
                        documents.setBirthday(DateUtils.asLocalDate((Date)travellerPassport.getBirthday()));
                        documents.setLastName(travellerPassport.getLastName());
                        documents.setGender(travellerPassport.getGender());
                        documents.setDocumentType(travellerPassport.getType());
                        documents.setCitizenship(travellerPassport.getCitizenship());
                        documents.setIssueOrganization(travellerPassport.getIssueOrganization());
                        documents.setFirstName(travellerPassport.getFirstName());
                        documents.setBirthPlace(travellerPassport.getBirthPlace());
                        documents.setNumber(travellerPassport.getNumber());
                        documents.setExpired(DateUtils.asLocalDate((Date)travellerPassport.getExpired()));
                        documents.setOriginCountry(travellerPassport.getOriginCountry());
                        documents.setMiddleName(travellerPassport.getMiddleName());
                        documents.setIssued(DateUtils.asLocalDate((Date)travellerPassport.getIssued()));
                        documents.setSecondName(travellerPassport.getSecondName());
                    }
                    BookingFileTravelerPanel travellerFullNode = new BookingFileTravelerPanel(false);
                    travellerFullNode.getProperties().put((Object)"model-uid", (Object)traveller.getUid());
                    new BookingFileTravelerPanelController(travellerFullNode, false).readData(vm);
                    BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace(view);
                    ((PlainGroupsWidget)((BookingFileTravelersPanel)bookingFileSpace.getTravelersTile().getFullNode()).getContent()).getViews().add((Object)travellerFullNode);
                    consumer.accept(traveller);
                });
            }
        }, ObservableMutex.lookup((Node)view));
    }

    private static /* synthetic */ void lambda$showAddTravellerFromProfileDialog$4(IndexListPane listPane, Node view, Consumer consumer) {
        BookingFileSpaceHelper.saveTravellerFromProfile((EntityReference<Person>)((PersonIndex)listPane.getSelectedItems().get(0)).getSource(), view, consumer);
    }
}

