/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.profile.CardPanel;
import com.gridnine.xtrip.common.fx.rpc.PCIDSSService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public final class CardsHelper {
    private CardsHelper() {
    }

    public static Card getShortcutCardFromView(CardPanel cardPanel) {
        Card shortcutCard = new Card();
        shortcutCard.setUid(cardPanel.getUidNode().getValue());
        shortcutCard.setCirUid(cardPanel.getCirUidNode().getValue());
        ValueHolder expDate = new ValueHolder();
        cardPanel.getExpirationDateNode().writeData((Object)expDate);
        shortcutCard.setExpiration(DateUtils.asDate((LocalDate)((LocalDate)expDate.get())));
        shortcutCard.setVendor((CardVendor)((ComboBoxWidget)cardPanel.getCardTypeCell().getPayload()).getValue());
        shortcutCard.setNameOnCard(cardPanel.getOwnerNode().getValue());
        shortcutCard.setNumber(cardPanel.getNumberNode().getValue());
        return shortcutCard;
    }

    public static void getAddressAndOpenWeb(PCIDSSServerExchangeSettings settings, Card shortcutCard, EntityReference<?> ref) {
        Notifications.get().submitTask(() -> {
            PCIDSSService service = (PCIDSSService)RpcServiceManager.get().getService(PCIDSSService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            String url = service.prepareNewCard(sic, shortcutCard, settings, ref);
            FxUtil.openUrl((String)url);
        }, Messages.General_Data_loading);
    }

    public static List<String> validateData(CardPanel panel) {
        ArrayList<String> result = new ArrayList<String>();
        if (TextUtil.isBlank((String)panel.getOwnerNode().getValue())) {
            result.add(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Error_card_owner);
        }
        ValueHolder expDate = new ValueHolder();
        panel.getExpirationDateNode().writeData((Object)expDate);
        if (expDate.get() == null) {
            result.add(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Error_expired_date);
        }
        return result;
    }

    public static CardPanel getNewCardPanel() {
        CardPanel dialogContainer = new CardPanel(false);
        dialogContainer.getNumberCell().setHidden(true);
        dialogContainer.getPopulateCardNumberCell().setHidden(true);
        dialogContainer.getUidCell().setHidden(true);
        dialogContainer.getCirUidCell().setHidden(true);
        dialogContainer.getUidNode().setValue(UUIDGenerator.generate((boolean)true).toString());
        return dialogContainer;
    }

    public static ComboBoxWidget<String> getWidgetForCard(ObservableList<CardPanel> listCardPanel) {
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(CardsHelper.getItemSupplier(listCardPanel));
        widget.setConverter(CardsHelper.getStringConverterForUidCard(listCardPanel));
        widget.setNoNulls(true);
        widget.guessPrefWidth();
        widget.setSortItems(false);
        return widget;
    }

    public static Supplier<List<String>> getItemSupplier(ObservableList<CardPanel> listCardPanel) {
        return () -> listCardPanel.stream().map(panel -> panel.getUidNode().getValue()).collect(Collectors.toList());
    }

    public static StringConverter<String> getStringConverterForUidCard(final ObservableList<CardPanel> listCardPanel) {
        return new StringConverter<String>(){

            public String toString(String uid) {
                int index = 0;
                StringBuilder sb = new StringBuilder();
                ArrayList<String> list = new ArrayList<String>();
                for (CardPanel panel : listCardPanel) {
                    ++index;
                    if (!panel.getUidNode().getValue().equals(uid)) continue;
                    if (panel.getNumberNode().getValue() != null) {
                        list.add(panel.getNumberNode().getValue());
                    }
                    if (panel.getCardTypeNode().getValue() == null) break;
                    list.add(((CardVendor)panel.getCardTypeNode().getValue()).toString());
                    break;
                }
                sb.append(index).append(". ");
                int size = list.size();
                if (size > 0) {
                    sb.append((String)list.get(0));
                }
                if (size > 1) {
                    sb.append(" (");
                    sb.append(String.join((CharSequence)" ", list.subList(1, size)));
                    sb.append(")");
                }
                return sb.toString();
            }

            public String fromString(String string) {
                return null;
            }
        };
    }
}

