/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public final class ContactsPaneHelper {
    public static final List<CommunicationType> PHONE_TYPES = Arrays.asList(CommunicationType.MOBILE, CommunicationType.HOME_PHONE, CommunicationType.FAX, CommunicationType.WORK_PHONE, CommunicationType.AGENCY, CommunicationType.CELL, CommunicationType.HOTEL);

    public static void configurePhonesTable(TableWidget<? extends ContactPhonesTableVM> tableWidget, Supplier<List<EntityReference<Organization>>> organizationsSupplier) {
        ComboBoxWidgetColumn typeColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("type");
        typeColumn.setItemsSupplier(() -> PHONE_TYPES);
        EntityBoxWidgetColumn organizationColumn = (EntityBoxWidgetColumn)tableWidget.getColumn("organization");
        if (organizationsSupplier != null) {
            organizationColumn.setHidden(false);
            organizationColumn.setItemsSupplier(organizationsSupplier, false);
        } else {
            organizationColumn.setHidden(true);
        }
        TextWidgetColumn countryCodeColumn = (TextWidgetColumn)tableWidget.getColumn("countryCode");
        TextWidgetColumn cityCodeColumn = (TextWidgetColumn)tableWidget.getColumn("cityCode");
        TextWidgetColumn phoneNumberColumn = (TextWidgetColumn)tableWidget.getColumn("phoneNumber");
        tableWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                TextFieldWidget countryCodeWidget = (TextFieldWidget)countryCodeColumn.getWidget(event.getRowIndex().intValue());
                countryCodeWidget.controlFocusedProperty().addListener((s, o, n) -> {
                    if (!n.booleanValue()) {
                        ContactsPaneHelper.validateNumber(countryCodeWidget);
                    }
                });
                TextFieldWidget cityCodeWidget = (TextFieldWidget)cityCodeColumn.getWidget(event.getRowIndex().intValue());
                cityCodeWidget.controlFocusedProperty().addListener((s, o, n) -> {
                    if (!n.booleanValue()) {
                        ContactsPaneHelper.validateNumber(cityCodeWidget);
                    }
                });
                TextFieldWidget phoneNumberWidget = (TextFieldWidget)phoneNumberColumn.getWidget(event.getRowIndex().intValue());
                phoneNumberWidget.controlFocusedProperty().addListener((s, o, n) -> {
                    if (n.booleanValue()) {
                        return;
                    }
                    ContactsPaneHelper.validateNumber(phoneNumberWidget);
                    if (TextUtil.isBlank((String)phoneNumberWidget.getValue())) {
                        return;
                    }
                    if (TextUtil.isBlank((String)countryCodeWidget.getValue()) || TextUtil.isBlank((String)cityCodeWidget.getValue())) {
                        Notifications.get().showFlashNotification(Messages.Enter_code_ofcountry_and_city, null);
                    }
                });
            }
        });
    }

    private static void validateNumber(TextFieldWidget widget) {
        String str = widget.getValue();
        if (TextUtil.isBlank((String)str)) {
            return;
        }
        String corrected = str.replaceAll("[^0-9]", "");
        if (corrected.equals(str)) {
            return;
        }
        widget.setValue(corrected);
    }

    private ContactsPaneHelper() {
    }
}

