/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCreateParametersPaneController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.StandardCreateBookingHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;

public final class CreateBookingHelper {
    public static void createBookingFile(CreateBookingCallback callback, boolean showCreateDialog) {
        if (!showCreateDialog && !"true".equalsIgnoreCase(System.getProperty("client.fx.booking_file_show_create_dialog"))) {
            BookingFileCreateParametersPaneVM parameters = new BookingFileCreateParametersPaneVM();
            parameters.setClient(Prefetched.getData().getRetailProfile());
            CreateBookingHelper.doCreateBooking(callback, parameters);
            return;
        }
        BookingFileCreateParametersPaneController parametersController = new BookingFileCreateParametersPaneController(false);
        new Dialog().setTitle(Messages.Creating_new_order).setBody((Node)parametersController.getView()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create_order, () -> {
            BookingFileCreateParametersPaneVM parameters = new BookingFileCreateParametersPaneVM();
            parametersController.writeData(parameters);
            CreateBookingHelper.doCreateBooking(callback, parameters);
        }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)parametersController.getView().getClientNode().valueProperty())).showGlobal();
    }

    private static void doCreateBooking(CreateBookingCallback callback, BookingFileCreateParametersPaneVM parameters) {
        List<CreateBookingHandler> handlers = CreateBookingHelper.getCreateBookingHandlers();
        Notifications.get().submitTask(() -> {
            BookingFile bf = new BookingFile();
            BookingFileUIData uiData = new BookingFileUIData();
            for (CreateBookingHandler handler : handlers) {
                handler.onCreateBegin(bf, uiData, parameters);
            }
            callback.onCreate(bf, uiData, parameters);
            for (CreateBookingHandler handler : handlers) {
                handler.onCreateEnd(bf, uiData, parameters);
            }
            FxUtil.submitToFxThread(() -> CreateBookingHelper.navigateTo((DataTransferPackage<BookingFile, BookingFileUIData>)new DataTransferPackage(EntityContainer.create((BaseEntity)bf), (Object)uiData)));
        }, Messages.Creating_new_order);
    }

    public static List<CreateBookingHandler> getCreateBookingHandlers() {
        ArrayList<CreateBookingHandler> result = new ArrayList<CreateBookingHandler>();
        result.add(new StandardCreateBookingHandler());
        result.addAll(ClientRegistry.get().allOf(CreateBookingHandler.TYPE).values());
        return result;
    }

    public static void navigateTo(DataTransferPackage<BookingFile, BookingFileUIData> dtp) {
        RootEntityActivityHandler.editNew(dtp, editor -> {
            if (((BookingFile)dtp.getContainer().getEntity()).getReservations().isEmpty()) {
                return;
            }
            Reservation reservation = (Reservation)((BookingFile)dtp.getContainer().getEntity()).getReservations().get(0);
            if (reservation.getProducts().isEmpty()) {
                return;
            }
            BookingFileSpace space = (BookingFileSpace)editor.getEditor();
            space.expand(space.getProductsTile());
        });
    }

    private CreateBookingHelper() {
    }

    @FunctionalInterface
    public static interface CreateBookingCallback {
        public void onCreate(BookingFile var1, BookingFileUIData var2, BookingFileCreateParametersPaneVM var3);
    }
}

