/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.DictEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.helpers.DictVersionActivityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictVersionParameters;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.assets.DictionaryVersion;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;

public final class DictEditorHelper {
    public static void showVersionsDialog(BaseDictionary dict, Node parent, ObservableMutex mutex) {
        Notifications.get().submitTask(() -> DictEditorHelper.loadVersions(dict, parent), mutex);
    }

    private static void loadVersions(BaseDictionary dict, Node view) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(DictionaryVersion.Property.dictId.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.code.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.createdBy.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.created.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.modifiedBy.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.modified.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.dataSource.name());
        query.getPreferredProperties().add(DictionaryVersion.Property.versionNotes.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DictionaryVersion.Property.dictId.name(), (Object)dict.getClass().getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DictionaryVersion.Property.code.name(), (Object)dict.getCode()));
        query.getCriteria().getOrders().put(DictionaryVersion.Property.created.name(), SortOrder.ASC);
        List dictionaryVersions = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), DictionaryVersion.class, query).getData();
        BaseDictionary lastVersion = ((DictService)RpcServiceManager.get().getService(DictService.class)).load(ServiceInvocationContext.get(), dict.toReference());
        dictionaryVersions.add(new DictionaryVersion(lastVersion));
        Map dictionaryVersionsByCreated = IntStream.range(0, dictionaryVersions.size()).mapToObj(i -> new DictionaryVersionWithNumber((DictionaryVersion)dictionaryVersions.get(i), i)).collect(Collectors.toMap(dv -> dv.getVersion().getCreated(), Function.identity()));
        List dictionaryVersionsWithNumbers = dictionaryVersionsByCreated.values().stream().sorted(Comparator.comparingInt(dv -> -dv.getVersionNumber())).collect(Collectors.toList());
        DictionaryVersionWithNumber lastVersionInfo = (DictionaryVersionWithNumber)dictionaryVersionsWithNumbers.get(0);
        final DictionaryVersionWithNumber currentVersionInfo = (DictionaryVersionWithNumber)dictionaryVersionsByCreated.get(dict.getModified());
        final CustomTableView tableView = new CustomTableView();
        tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumnSettings colSettings = new TableColumnSettings();
        colSettings.setDisplayName("\u2116");
        colSettings.setRenderer((Renderer)StandardRenderers.NUMBER_INTEGRAL);
        colSettings.setId("number");
        colSettings.setSortable(false);
        colSettings.setPrefWidth(Double.valueOf(50.0));
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersionNumber() + 1));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Created);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("createdBy");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersion().getCreatedBy()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.Date_of_creation);
        colSettings.setRenderer((Renderer)StandardRenderers.DATE_TIME);
        colSettings.setId("created");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersion().getCreated()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Changed);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("modifiedBy");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersion().getModifiedBy()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Date_of_change);
        colSettings.setRenderer((Renderer)StandardRenderers.DATE_TIME);
        colSettings.setId("modified");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersion().getModified()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.VersionsHelper_Source);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("dataSource");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersion().getDataSource()));
        colSettings = new TableColumnSettings();
        colSettings.setDisplayName(Messages.Comment);
        colSettings.setRenderer((Renderer)StandardRenderers.GENERIC);
        colSettings.setId("notes");
        colSettings.setSortable(false);
        tableView.getColumns().add((Object)colSettings.createColumn(info -> info.getVersion().getVersionNotes()));
        tableView.setInterlacingHighlight(true);
        tableView.getItems().addAll(dictionaryVersionsWithNumbers);
        FxUtil.submitToFxThread(() -> {
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.VersionsHelper_List_of_versions).setBody((Node)tableView).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Open, () -> {
                for (DictionaryVersionWithNumber info : tableView.getSelectionModel().getSelectedItems()) {
                    if (lastVersionInfo.equals(info)) {
                        DictEditingService.get().open(dict.toReference());
                        continue;
                    }
                    try {
                        DictEditorHelper.open(info);
                    }
                    catch (NullPointerException exception) {
                        ArrayList<StackTraceElement> incidentStackTraces = new ArrayList<StackTraceElement>();
                        incidentStackTraces.add(IncidentsHelper.getContextStackTraceElement((String)"DictId", (String)dict.getClass().getName()));
                        incidentStackTraces.add(IncidentsHelper.getContextStackTraceElement((String)"DictCaption", (String)dict.toReference().getCaption()));
                        incidentStackTraces.add(IncidentsHelper.getContextStackTraceElement((String)"DictCode", (String)dict.getCode()));
                        incidentStackTraces.forEach(incident -> {
                            NullPointerException cfr_ignored_0 = (NullPointerException)IncidentsHelper.addStackTraceElement((Throwable)exception, (StackTraceElement[])new StackTraceElement[]{incident});
                        });
                        throw exception;
                    }
                }
            }, (BooleanExpression)new BooleanBinding(){
                {
                    this.bind(new Observable[]{tableView.getSelectionModel().getSelectedItems()});
                }

                protected boolean computeValue() {
                    DictionaryVersionWithNumber info = (DictionaryVersionWithNumber)tableView.getSelectionModel().getSelectedItem();
                    return info != null && currentVersionInfo != null && currentVersionInfo.getVersionNumber() != info.getVersionNumber();
                }
            });
            dialog.show(view);
        });
    }

    private static void open(DictionaryVersionWithNumber version) {
        DictVersionParameters data = new DictVersionParameters();
        DictHandler handler = DictHandler.forDictClass((String)version.getVersion().getDictId());
        data.handlerId = handler.getId();
        data.code = version.getVersion().getCode();
        data.versionUid = version.getVersion().getUid();
        data.versionNumber = version.getVersionNumber();
        String token = data.handlerId + '|' + data.code + '|' + data.versionUid;
        NavigationParameters parameters = new NavigationParameters();
        parameters.setParameters((Object)data);
        ActivityManager.get().navigate(token, (ActivityHandler)DictVersionActivityHandler.INSTANCE, parameters);
    }

    static class DictionaryVersionWithNumber {
        private final DictionaryVersion version;
        private final int versionNumber;

        public DictionaryVersionWithNumber(DictionaryVersion version, int versionNumber) {
            this.version = version;
            this.versionNumber = versionNumber;
        }

        public DictionaryVersion getVersion() {
            return this.version;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }
    }
}

