/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class DictHelper {
    public static String toString(DictItem dictItem) {
        return DictHelper.toString(dictItem, LocaleManager.get().getCurrentLocale());
    }

    public static String toString(DictItem dictItem, Locale locale) {
        String result = null;
        if (dictItem == null) {
            result = "";
        } else {
            Map<Locale, String> translations = DictHelper.translations(dictItem);
            if (!translations.isEmpty()) {
                result = (String)MiscUtil.findByLocale(translations, (Locale)locale);
                if (TextUtil.isBlank((String)result) && !MiscUtil.equals((Object)locale, (Object)Locale.ENGLISH)) {
                    result = (String)MiscUtil.findByLocale(translations, (Locale)Locale.ENGLISH);
                }
                if (TextUtil.isBlank((String)result)) {
                    result = translations.values().iterator().next();
                }
            }
        }
        result = result == null ? dictItem.getReference().getCode() : result;
        return result;
    }

    private static Map<Locale, String> translations(DictItem dictItem) {
        Object v = dictItem.getFields().get(BaseDictionary.Property.translations.name());
        Map result = v instanceof Map ? (Map)v : Collections.emptyMap();
        return result;
    }
}

