/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.helpers.DiffItem;
import com.gridnine.xtrip.client.fx.standard.helpers.DiffViewPane;
import com.gridnine.xtrip.client.fx.standard.helpers.DiffViewParameters;
import com.gridnine.xtrip.client.fx.standard.helpers.Introspector;
import com.gridnine.xtrip.client.fx.standard.helpers.Introspectors;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.Identity;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javafx.util.Pair;

class DiffViewActivityHandler
extends ActivityHandler<DiffViewPane, DiffViewParameters> {
    private static final String ID = "diff-view-activity-handler";
    static final DiffViewActivityHandler INSTANCE = new DiffViewActivityHandler();

    private DiffViewActivityHandler() {
    }

    public String getId() {
        return ID;
    }

    protected boolean isHighlighted(ActivityState<DiffViewPane, DiffViewParameters> state) {
        return false;
    }

    protected DiffViewPane createView(ActivityState<DiffViewPane, DiffViewParameters> state) throws Exception {
        DiffViewParameters params = (DiffViewParameters)state.getParameters();
        DiffViewPane result = new DiffViewPane();
        result.setDisable(true);
        Notifications.get().submitTask(() -> {
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            EntityContainer ctr1 = entityService.load(ServiceInvocationContext.get(), params.ref.getType(), params.ref.getUid(), params.version1, null).getContainer();
            EntityContainer ctr2 = entityService.load(ServiceInvocationContext.get(), params.ref.getType(), params.ref.getUid(), params.version2, null).getContainer();
            if (ctr1 == null) {
                Notifications.get().showFlashNotification(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e %s", params.version1));
                return;
            }
            if (ctr2 == null) {
                Notifications.get().showFlashNotification(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e %s", params.version2));
                return;
            }
            FxUtil.submitToFxThread(() -> {
                TreeItem root = new TreeItem();
                root.setValue((Object)new DiffItem(ctr1.getEntityType().getName(), ctr1.getUid(), ctr2.getUid()));
                this.buildItems(Collections.newSetFromMap(new IdentityHashMap()), (TreeItem<DiffItem>)root, ctr1.getEntity(), ctr2.getEntity());
                result.populateData(ctr1, ctr2, (TreeItem<DiffItem>)root);
                result.setDisable(false);
            });
        }, state.getMutex());
        return result;
    }

    private <T> void buildItems(Set<Object> seen, TreeItem<DiffItem> parent, T ett1, T ett2) {
        int i;
        int size;
        TreeItem colItem;
        Introspector introspector;
        if (ett1 == null && ett2 == null) {
            return;
        }
        if (ett1 instanceof Identity || ett2 instanceof Identity) {
            parent.getChildren().add((Object)new TreeItem((Object)new DiffItem("UID", ett1 instanceof Identity ? ((Identity)ett1).getUid() : null, ett2 instanceof Identity ? ((Identity)ett2).getUid() : null)));
        }
        if (ett1 != null && seen.contains(ett1) || ett2 != null && seen.contains(ett2)) {
            return;
        }
        if (ett1 != null) {
            seen.add(ett1);
        }
        if (ett2 != null) {
            seen.add(ett2);
        }
        if ((introspector = Introspectors.getFor(ett1 == null ? ett2 : ett1)) == null) {
            return;
        }
        for (Pair<String, Function<Object, Object>> pair : introspector.getProperties()) {
            T val1 = ett1 == null ? null : (T)((Function)pair.getValue()).apply(ett1);
            T val2 = ett2 == null ? null : (T)((Function)pair.getValue()).apply(ett2);
            TreeItem child = new TreeItem((Object)new DiffItem((String)pair.getKey(), this.prepareValue(val1), this.prepareValue(val2)));
            parent.getChildren().add((Object)child);
            if (!Introspectors.isAwareOf(val1) && !Introspectors.isAwareOf(val2)) continue;
            this.buildItems(seen, (TreeItem<DiffItem>)child, val1, val2);
        }
        for (Pair<String, Function<Object, Object>> pair : introspector.getCollections()) {
            colItem = new TreeItem((Object)new DiffItem((String)pair.getKey(), null, null));
            parent.getChildren().add((Object)colItem);
            List col1 = ett1 == null ? Collections.emptyList() : (List)((Function)pair.getValue()).apply(ett1);
            List col2 = ett2 == null ? Collections.emptyList() : (List)((Function)pair.getValue()).apply(ett2);
            size = Math.max(col1.size(), col2.size());
            for (i = 0; i < size; ++i) {
                T val1 = i < col1.size() ? (T)col1.get(i) : null;
                T val2 = i < col2.size() ? (T)col2.get(i) : null;
                TreeItem child = new TreeItem((Object)new DiffItem(String.valueOf(i + 1), this.prepareValue(val1), this.prepareValue(val2)));
                colItem.getChildren().add((Object)child);
                if (!Introspectors.isAwareOf(val1) && !Introspectors.isAwareOf(val2)) continue;
                this.buildItems(seen, (TreeItem<DiffItem>)child, val1, val2);
            }
        }
        for (Pair<String, Function<Object, Object>> pair : introspector.getMaps()) {
            colItem = new TreeItem((Object)new DiffItem((String)pair.getKey(), null, null));
            parent.getChildren().add((Object)colItem);
            List map1 = ett1 == null ? Collections.emptyList() : (List)((Function)pair.getValue()).apply(ett1);
            List map2 = ett2 == null ? Collections.emptyList() : (List)((Function)pair.getValue()).apply(ett2);
            size = Math.max(map1.size(), map2.size());
            for (i = 0; i < size; ++i) {
                Object key1 = i < map1.size() ? ((Map.Entry)map1.get(i)).getKey() : null;
                Object key2 = i < map2.size() ? ((Map.Entry)map2.get(i)).getKey() : null;
                T val1 = i < map1.size() ? (T)((Map.Entry)map1.get(i)).getValue() : null;
                T val2 = i < map2.size() ? (T)((Map.Entry)map2.get(i)).getValue() : null;
                colItem.getChildren().add((Object)new TreeItem((Object)new DiffItem(i + 1 + " key", key1, key2)));
                TreeItem valueChild = new TreeItem((Object)new DiffItem(i + 1 + " value", this.prepareValue(val1), this.prepareValue(val2)));
                colItem.getChildren().add((Object)valueChild);
                if (!Introspectors.isAwareOf(val1) && !Introspectors.isAwareOf(val2)) continue;
                this.buildItems(seen, (TreeItem<DiffItem>)valueChild, val1, val2);
            }
        }
        parent.getChildren().sort((lhs, rhs) -> {
            String lValue = (String)((DiffItem)lhs.getValue()).property.getValue();
            String rValue = (String)((DiffItem)rhs.getValue()).property.getValue();
            if ("uid".equalsIgnoreCase(lValue)) {
                return Integer.MIN_VALUE;
            }
            if ("uid".equalsIgnoreCase(rValue)) {
                return Integer.MAX_VALUE;
            }
            return lValue.compareToIgnoreCase(rValue);
        });
    }

    private Object prepareValue(Object value) {
        if (value == null) {
            return null;
        }
        if (Introspectors.isAwareOf(value)) {
            return value.getClass().getName();
        }
        return value;
    }

    protected Serializer<DiffViewParameters> getSerializer() {
        return Serializer.javaSerializer();
    }

    protected void saveChanges(ActivityState<DiffViewPane, DiffViewParameters> state) throws Exception {
    }
}

