/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.DelayedChangeListener;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.DiffItem;
import com.gridnine.xtrip.client.fx.standard.helpers.TableCell;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Duration;

class DiffViewPane
extends BaseContentPane {
    protected final TreeTableView<DiffItem> tableView;
    private StringProperty caption;
    private boolean hideNonDiffs;
    private TreeItem<DiffItem> data;
    private SearchTextField patternField;

    DiffViewPane() {
        this.getStyleClass().add((Object)"xtrip-editor-pane");
        this.tableView = new TreeTableView();
        this.tableView.getStyleClass().addAll((Object[])new String[]{"custom-table-view", "xtrip-scroll-alt"});
        this.tableView.setShowRoot(false);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.setColumnResizePolicy(TreeTableView.CONSTRAINED_RESIZE_POLICY);
        TreeTableColumn col = new TreeTableColumn("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e");
        col.setId("property");
        col.setCellValueFactory(param -> ((DiffItem)param.getValue().getValue()).property);
        col.setCellFactory(column -> new TableCell());
        col.setSortable(false);
        this.tableView.getColumns().add((Object)col);
        col = new TreeTableColumn();
        col.setId("leftValue");
        col.setCellValueFactory(param -> ((DiffItem)param.getValue().getValue()).leftValue);
        col.setCellFactory(column -> new TableCell());
        col.setSortable(false);
        this.tableView.getColumns().add((Object)col);
        col = new TreeTableColumn();
        col.setId("rightValue");
        col.setCellValueFactory(param -> ((DiffItem)param.getValue().getValue()).rightValue);
        col.setCellFactory(column -> new TableCell());
        col.setSortable(false);
        this.tableView.getColumns().add((Object)col);
        col = new TreeTableColumn();
        col.setId("marker");
        col.setCellValueFactory(param -> param.getValue().valueProperty());
        col.setPrefWidth(20.0);
        col.setMinWidth(20.0);
        col.setMaxWidth(20.0);
        col.setCellFactory(column -> new TreeTableCell<DiffItem, DiffItem>(){

            protected void updateItem(DiffItem item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null || item.differs == null) {
                    this.setStyle("-fx-background-color:antiquewhite");
                    return;
                }
                String color = item.differs != false ? "orangered" : "mediumseagreen";
                this.setStyle("-fx-background-color:" + color);
            }
        });
        col.setSortable(false);
        this.tableView.getColumns().add((Object)col);
        this.composePane((Node)this.tableView, this.buildHeader(), null, null);
    }

    private Node buildHeader() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        Label captionLabel = new Label("\u0421\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439");
        captionLabel.getStyleClass().add((Object)"xtrip-page-label");
        GridPane.setHgrow((Node)captionLabel, (Priority)Priority.ALWAYS);
        this.caption = captionLabel.textProperty();
        nodes.add(captionLabel);
        CheckBoxWidget cb = new CheckBoxWidget(false);
        cb.setMinWidth(Double.NEGATIVE_INFINITY);
        cb.setText("\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u043b\u0438\u0447\u0438\u044f");
        cb.selectedProperty().addListener((s, o, n) -> {
            this.hideNonDiffs = n;
            this.updateTableData();
        });
        nodes.add(cb);
        this.patternField = new SearchTextField(){

            public void clear() {
                super.clear();
                DiffViewPane.this.tableView.getSelectionModel().clearSelection();
            }
        };
        this.patternField.getStyleClass().add((Object)"xtrip-pattern-field");
        this.patternField.setPrefWidth(250.0);
        this.patternField.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPane.setHgrow((Node)this.patternField, (Priority)Priority.NEVER);
        Tooltip.install((Node)this.patternField.getLeft(), (Tooltip)new Tooltip("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430"));
        this.patternField.textProperty().addListener((ChangeListener)new DelayedChangeListener<String>(Duration.millis((double)700.0)){

            protected void handle(String value) {
                DiffViewPane.this.applySearch();
            }
        });
        nodes.add(this.patternField);
        GridPane result = new GridPane();
        result.getStyleClass().add((Object)"editor-header-pane");
        result.addRow(0, nodes.toArray(new Node[nodes.size()]));
        return result;
    }

    void applySearch() {
        TreeTableView.TreeTableViewSelectionModel selectionModel = this.tableView.getSelectionModel();
        selectionModel.clearSelection();
        String pattern = this.patternField.getText();
        if (TextUtil.isBlank((String)pattern)) {
            return;
        }
        this.search((TreeTableView.TreeTableViewSelectionModel<DiffItem>)selectionModel, (TreeItem<DiffItem>)this.tableView.getRoot(), pattern.toLowerCase());
        ObservableList selectedIndices = selectionModel.getSelectedIndices();
        if (!selectedIndices.isEmpty()) {
            this.tableView.scrollTo(((Integer)selectedIndices.get(0)).intValue());
        }
    }

    private void search(TreeTableView.TreeTableViewSelectionModel<DiffItem> selectionModel, TreeItem<DiffItem> item, String pattern) {
        if (item == null) {
            return;
        }
        DiffItem value = (DiffItem)item.getValue();
        if (this.match(value, pattern)) {
            selectionModel.select(item);
        }
        for (TreeItem child : item.getChildren()) {
            this.search(selectionModel, (TreeItem<DiffItem>)child, pattern);
        }
    }

    private boolean match(DiffItem value, String pattern) {
        if (value == null) {
            return false;
        }
        if (((String)value.property.getValue()).toLowerCase().contains(pattern)) {
            return true;
        }
        if (value.leftValue.getValue() != null && ((String)value.leftValue.getValue()).toLowerCase().contains(pattern)) {
            return true;
        }
        return value.rightValue.getValue() != null && ((String)value.rightValue.getValue()).toLowerCase().contains(pattern);
    }

    <T extends BaseEntity> void populateData(EntityContainer<T> ctr1, EntityContainer<T> ctr2, TreeItem<DiffItem> root) {
        this.data = root;
        for (TreeTableColumn col : this.tableView.getColumns()) {
            switch (col.getId()) {
                case "leftValue": {
                    col.setText("\u0412\u0435\u0440\u0441\u0438\u044f " + (ctr1.getVersionInfo().getVersionNumber() + 1));
                    break;
                }
                case "rightValue": {
                    col.setText("\u0412\u0435\u0440\u0441\u0438\u044f " + (ctr2.getVersionInfo().getVersionNumber() + 1));
                    break;
                }
            }
        }
        this.caption.set((Object)String.format("\u0421\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 %s \u0438 %s \u0434\u043b\u044f %s", ctr1.getVersionInfo().getVersionNumber() + 1, ctr2.getVersionInfo().getVersionNumber() + 1, ctr1.getEntity().toString()));
        this.updateTableData();
    }

    private void updateTableData() {
        TreeItem root;
        if (!this.hideNonDiffs) {
            root = this.data;
        } else {
            root = new TreeItem(this.data.getValue());
            this.copyDiffs(this.data, (TreeItem<DiffItem>)root);
        }
        UiUtil.expand(root);
        this.tableView.setRoot(root);
        this.applySearch();
    }

    private void copyDiffs(TreeItem<DiffItem> src, TreeItem<DiffItem> dest) {
        for (TreeItem srcChild : src.getChildren()) {
            if (!this.hasDiffs((TreeItem<DiffItem>)srcChild)) continue;
            TreeItem destChild = new TreeItem(srcChild.getValue());
            dest.getChildren().add((Object)destChild);
            this.copyDiffs((TreeItem<DiffItem>)srcChild, (TreeItem<DiffItem>)destChild);
        }
    }

    private boolean hasDiffs(TreeItem<DiffItem> item) {
        if (((DiffItem)item.getValue()).differs != null && ((DiffItem)item.getValue()).differs.booleanValue()) {
            return true;
        }
        for (TreeItem child : item.getChildren()) {
            if (!this.hasDiffs((TreeItem<DiffItem>)child)) continue;
            return true;
        }
        return false;
    }
}

