/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.standard.helpers.Introspector;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.util.Pair;

final class Introspectors {
    private static final Map<String, Introspector> CUSTOM = new HashMap<String, Introspector>();

    Introspectors() {
    }

    static boolean isAwareOf(Object obj) {
        if (obj == null) {
            return false;
        }
        String className = obj.getClass().getName();
        return CUSTOM.containsKey(className) || MetaRegistryHelper.getEntityType((String)className) != null;
    }

    static Introspector getFor(Object obj) {
        if (obj == null) {
            return null;
        }
        Introspector result = CUSTOM.get(obj.getClass().getName());
        return result != null ? result : Introspectors.createStandard(obj.getClass());
    }

    private static Introspector createStandard(Class<?> cls) {
        final EntityType entityType = MetaRegistryHelper.getEntityType((String)cls.getName());
        return new Introspector(){

            @Override
            public List<Pair<String, Function<Object, Object>>> getProperties() {
                if (entityType == null) {
                    return Collections.emptyList();
                }
                return MetaRegistryHelper.getAllProperties((EntityType)entityType).values().stream().map(prop -> new Pair((Object)prop.getId(), obj -> Introspectors.getPropertyValue(prop, obj))).collect(Collectors.toList());
            }

            @Override
            public List<Pair<String, Function<Object, List<Object>>>> getCollections() {
                if (entityType == null) {
                    return Collections.emptyList();
                }
                return MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values().stream().filter(coll -> coll.getKeyType() == null).map(coll -> new Pair((Object)coll.getId(), obj -> Introspectors.getCollectionValue(coll, obj))).collect(Collectors.toList());
            }

            @Override
            public List<Pair<String, Function<Object, List<Map.Entry<Object, Object>>>>> getMaps() {
                if (entityType == null) {
                    return Collections.emptyList();
                }
                return MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values().stream().filter(coll -> coll.getKeyType() != null).map(coll -> new Pair((Object)coll.getId(), obj -> Introspectors.getMapValue(coll, obj))).collect(Collectors.toList());
            }
        };
    }

    static Object getPropertyValue(Property prop, Object obj) {
        if (!(obj instanceof Introspectable)) {
            return null;
        }
        Object value = null;
        try {
            value = ((Introspectable)obj).getValue(prop.getId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (value == null) {
            return null;
        }
        if (prop.isHistorical()) {
            return HistoricalValueHelper.getHistoricalValue((List)((List)value));
        }
        return value;
    }

    static List<Object> getCollectionValue(EntityCollection coll, Object obj) {
        if (!(obj instanceof Introspectable)) {
            return Collections.emptyList();
        }
        Collection value = (Collection)((Introspectable)obj).getValue(coll.getId());
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        return new ArrayList<Object>(value);
    }

    static List<Map.Entry<Object, Object>> getMapValue(EntityCollection coll, Object obj) {
        if (!(obj instanceof Introspectable)) {
            return Collections.emptyList();
        }
        Map value = (Map)((Introspectable)obj).getValue(coll.getId());
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Map.Entry<Object, Object>>(value.entrySet());
    }

    static {
        CUSTOM.put(RuleSet.class.getName(), new Introspector(){

            @Override
            public List<Pair<String, Function<Object, Object>>> getProperties() {
                return Collections.singletonList(new Pair((Object)"modified", obj -> ((RuleSet)obj).getModified()));
            }

            @Override
            public List<Pair<String, Function<Object, List<Object>>>> getCollections() {
                return Collections.singletonList(new Pair((Object)"rules", obj -> ((RuleSet)obj).getRules()));
            }

            @Override
            public List<Pair<String, Function<Object, List<Map.Entry<Object, Object>>>>> getMaps() {
                return Collections.emptyList();
            }
        });
        CUSTOM.put(RuleSettings.class.getName(), new Introspector(){

            @Override
            public List<Pair<String, Function<Object, Object>>> getProperties() {
                return Arrays.asList(new Pair((Object)"target", obj -> ((RuleSettings)obj).getTarget()), new Pair((Object)"name", obj -> ((RuleSettings)obj).getName()), new Pair((Object)"remarks", obj -> ((RuleSettings)obj).getRemarks()), new Pair((Object)"periodBegin", obj -> ((RuleSettings)obj).getPeriodBegin()), new Pair((Object)"periodEnd", obj -> ((RuleSettings)obj).getPeriodEnd()), new Pair((Object)"filteringCategory", obj -> ((RuleSettings)obj).getFilteringCategory()), new Pair((Object)"ignoreOnExport", obj -> ((RuleSettings)obj).isIgnoreOnExport()), new Pair((Object)"preserveOnImport", obj -> ((RuleSettings)obj).isPreserveOnImport()), new Pair((Object)"description", obj -> ((RuleSettings)obj).getDescription()), new Pair((Object)"revisionDate", obj -> ((RuleSettings)obj).getRevisionDate()));
            }

            @Override
            public List<Pair<String, Function<Object, List<Object>>>> getCollections() {
                return Arrays.asList(new Pair((Object)"restrictions", obj -> ((RuleSettings)obj).getRestrictions()), new Pair((Object)"results", obj -> ((RuleSettings)obj).getResults()));
            }

            @Override
            public List<Pair<String, Function<Object, List<Map.Entry<Object, Object>>>>> getMaps() {
                return Collections.singletonList(new Pair((Object)"attributes", obj -> new ArrayList(((RuleSettings)obj).getAttributes().entrySet())));
            }
        });
        CUSTOM.put(RuleRestriction.class.getName(), new Introspector(){

            @Override
            public List<Pair<String, Function<Object, Object>>> getProperties() {
                return Arrays.asList(new Pair((Object)"property", obj -> ((RuleRestriction)obj).getProperty()), new Pair((Object)"condition", obj -> ((RuleRestriction)obj).getCondition()), new Pair((Object)"value", obj -> ((RuleRestriction)obj).getValue()));
            }

            @Override
            public List<Pair<String, Function<Object, List<Object>>>> getCollections() {
                return Collections.emptyList();
            }

            @Override
            public List<Pair<String, Function<Object, List<Map.Entry<Object, Object>>>>> getMaps() {
                return Collections.emptyList();
            }
        });
        CUSTOM.put(RuleResult.class.getName(), new Introspector(){

            @Override
            public List<Pair<String, Function<Object, Object>>> getProperties() {
                return Arrays.asList(new Pair((Object)"action", obj -> ((RuleResult)obj).getAction()), new Pair((Object)"value", obj -> ((RuleResult)obj).getValue()));
            }

            @Override
            public List<Pair<String, Function<Object, List<Object>>>> getCollections() {
                return Collections.emptyList();
            }

            @Override
            public List<Pair<String, Function<Object, List<Map.Entry<Object, Object>>>>> getMaps() {
                return Collections.emptyList();
            }
        });
    }
}

