/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsPanel;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;

enum RelatedDocumentsActions implements TileAction<Node, RelatedDocumentsPanel>
{
    ADD_DOCUMENT{

        public String getName(Tile<Node, RelatedDocumentsPanel> tile) {
            return Messages.Add_document;
        }

        public String getDescription(Tile<Node, RelatedDocumentsPanel> tile) {
            return Messages.Add_document;
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, RelatedDocumentsPanel> tile) {
            return !ViewController.forView((Node)tile.getFullNode()).isReadonly();
        }

        public void execute(Control source, Tile<Node, RelatedDocumentsPanel> tile, boolean alt) {
            DataViewWidgetHelper.showAddFileDialog(source, tile, null);
        }
    }
    ,
    DELETE_DOCUMENT{

        public String getName(Tile<Node, RelatedDocumentsPanel> tile) {
            return Messages.Delete_document;
        }

        public String getDescription(Tile<Node, RelatedDocumentsPanel> tile) {
            return Messages.Delete_document;
        }

        public double getWeight() {
            return 5.0;
        }

        public boolean isEnabled(Tile<Node, RelatedDocumentsPanel> tile) {
            return !ViewController.forView((Node)tile.getFullNode()).isReadonly();
        }

        public void execute(Control source, final Tile<Node, RelatedDocumentsPanel> tile, boolean alt) {
            String accept;
            String info;
            ObservableList selectedFiles = ((DataViewWidget)((RelatedDocumentsPanel)tile.getFullNode()).getDocumentsCard().getContent()).getTableView().getSelectionModel().getSelectedItems();
            if (selectedFiles.isEmpty()) {
                return;
            }
            if (selectedFiles.size() == 1) {
                info = Messages.Delete_info;
                accept = Messages.Delete_document;
            } else {
                info = Messages.Delete_info2;
                accept = Messages.Delete_document2;
            }
            Dialog.confirm((Node)source, (String)Messages.Deleting, (String)info, (String)accept, () -> Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask(selectedFiles.stream().map(idx -> idx.getReference()).collect(Collectors.toList())){

                @Override
                protected void execute() throws Exception {
                    super.execute();
                    FxUtil.submitToFxThread(() -> ((DataViewWidget)((RelatedDocumentsPanel)tile.getFullNode()).getDocumentsCard().getContent()).reloadData());
                }
            }), null);
        }
    };

}

