/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsDataItemVM;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsFilterContainer;
import com.gridnine.xtrip.client.fx.standard.helpers.RelatedDocumentsConfiguration;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.finance.CreditSlipIndex;
import com.gridnine.xtrip.common.model.fiscal.ReceiptIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.util.Pair;

class RelatedDocumentsFilterableDataViewHandler
extends FilterableDataViewHandler<RelatedDocumentsDataItemVM, RelatedDocumentsFilterContainer> {
    Supplier<EntityReference<?>> ownerSupplier;
    RelatedDocumentsConfiguration configuration;

    RelatedDocumentsFilterableDataViewHandler(Supplier<EntityReference<?>> ownerSupplier, RelatedDocumentsConfiguration configuration) {
        super(() -> new RelatedDocumentsFilterContainer(false), false);
        this.ownerSupplier = ownerSupplier;
        this.configuration = configuration;
    }

    protected int getLimit() {
        return Integer.MAX_VALUE;
    }

    protected int getOffset() {
        return 0;
    }

    protected DataViewWidget<RelatedDocumentsDataItemVM> getWidget() {
        if (!this.configuration.isFiltersVisible()) {
            return null;
        }
        return super.getWidget();
    }

    protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
        EntityReference<?> owner = this.ownerSupplier.get();
        if (Objects.isNull(owner)) {
            this.getData().clear();
            return;
        }
        Notifications.get().submitTask(() -> {
            ArrayList data = new ArrayList();
            String name = ((RelatedDocumentsFilterContainer)this.getFilteringPane().getContent()).getNameNode().getValue();
            DocumentType type = (DocumentType)((RelatedDocumentsFilterContainer)this.getFilteringPane().getContent()).getContentTypeNode().getValue();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            SearchQuery searchQuery = new SearchQuery();
            List criterions = searchQuery.getCriteria().getCriterions();
            if (TextUtil.nonBlank((String)name)) {
                criterions.add(SearchCriterion.ilike((String)BasicDocumentIndex.Property.name.name(), (String)("%" + name + "%")));
            }
            if (Objects.nonNull(type)) {
                criterions.add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)type));
            }
            SearchCriterion ownerCriterion = SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)owner);
            if (!BookingFile.class.isAssignableFrom(owner.getType())) {
                ownerCriterion = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{ownerCriterion, SearchCriterion.contains((String)BasicDocumentIndex.Property.ownersUids.name(), (Object)owner.getUid())});
            }
            criterions.add(ownerCriterion);
            entityService.search(ServiceInvocationContext.get(), BasicDocumentIndex.class, searchQuery).forEach(index -> {
                RelatedDocumentsDataItemVM vm = new RelatedDocumentsDataItemVM();
                vm.setDate(index.getCreated());
                vm.setCreationDate((String)StandardRenderers.DATE_TIME.apply((Object)index.getCreated()));
                vm.setName(index.getTitle());
                if (index.getContentType() != null) {
                    vm.setContentType(index.getContentType().toString());
                }
                vm.setReference(index.getSource());
                data.add(vm);
            });
            searchQuery = new SearchQuery();
            criterions = searchQuery.getCriteria().getCriterions();
            if (TextUtil.nonBlank((String)name)) {
                criterions.add(SearchCriterion.ilike((String)CreditSlipIndex.Property.name.name(), (String)("%" + name + "%")));
            }
            if (Objects.nonNull(type)) {
                criterions.add(SearchCriterion.eq((String)CreditSlipIndex.Property.type.name(), (Object)type));
            }
            criterions.add(SearchCriterion.contains((String)CreditSlipIndex.Property.owners.name(), (Object)owner));
            entityService.search(ServiceInvocationContext.get(), CreditSlipIndex.class, searchQuery).forEach(index -> {
                RelatedDocumentsDataItemVM vm = new RelatedDocumentsDataItemVM();
                vm.setDate(index.getDate());
                vm.setCreationDate((String)StandardRenderers.DATE_TIME.apply((Object)index.getDate()));
                vm.setName(index.getName());
                if (index.getContentType() != null) {
                    vm.setContentType(index.getContentType().toString());
                }
                vm.setReference(index.getSource());
                data.add(vm);
            });
            searchQuery = new SearchQuery();
            criterions = searchQuery.getCriteria().getCriterions();
            if (TextUtil.nonBlank((String)name)) {
                criterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)ReceiptIndex.Property.productNumbers.name(), (String)("%" + name + "%")), SearchCriterion.ilike((String)ReceiptIndex.Property.fullNumber.name(), (String)("%" + name + "%"))}));
            }
            if (Objects.nonNull(type)) {
                criterions.add(SearchCriterion.eq((String)ReceiptIndex.Property.type.name(), (Object)type));
            }
            criterions.add(SearchCriterion.eq((String)ReceiptIndex.Property.owner.name(), (Object)owner));
            entityService.search(ServiceInvocationContext.get(), ReceiptIndex.class, searchQuery).forEach(index -> {
                RelatedDocumentsDataItemVM vm = new RelatedDocumentsDataItemVM();
                vm.setName(index.getDescription());
                vm.setDate(index.getCreated());
                vm.setCreationDate((String)StandardRenderers.DATE_TIME.apply((Object)index.getCreated()));
                vm.setContentType(ContentType.FISCAL_RECEIPT.toString());
                vm.setReference(index.getSource());
                data.add(vm);
            });
            Collections.sort(data, (lhs, rhs) -> MiscUtil.compare((Date)rhs.getDate(), (Date)lhs.getDate()));
            FxUtil.submitToFxThread(() -> this.getData().setAll((Collection)data));
        }, this.getMutex());
    }
}

