/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;

public final class RpcEntityHelper {
    public static EntityReference<Organization> findOrganization(String code) throws Exception {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
        sq.getPreferredProperties().add(OrganizationIndex.Property.code.name());
        List list = entityService.search(ServiceInvocationContext.get(), OrganizationIndex.class, sq);
        return list.isEmpty() ? null : ((OrganizationIndex)list.get(0)).getSource();
    }

    public static String getOrganizationCode(EntityReference<Organization> ref) throws Exception {
        if (ref == null) {
            return null;
        }
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)ref.getUid()));
        sq.getPreferredProperties().add(OrganizationIndex.Property.code.name());
        List list = entityService.search(ServiceInvocationContext.get(), OrganizationIndex.class, sq);
        return list.isEmpty() ? null : ((OrganizationIndex)list.get(0)).getCode();
    }

    public static <E extends BaseEntity> EntityReference<E> getReference(Class<E> cls, String uid) throws Exception {
        if (uid == null) {
            return null;
        }
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        List refs = entityService.getReferences(ServiceInvocationContext.get(), cls, new String[]{uid});
        return refs.isEmpty() ? null : (EntityReference)refs.get(0);
    }

    private RpcEntityHelper() {
    }
}

