/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.model.booking.BookingFileCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHandler;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.Date;
import java.util.stream.Stream;

class StandardCreateBookingHandler
implements CreateBookingHandler {
    StandardCreateBookingHandler() {
    }

    @Override
    public void onCreateBegin(BookingFile bookingFile, BookingFileUIData uiData, BookingFileCreateParametersPaneVM parameters) {
        Stream<Object> reservations;
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(agentData.getAgency());
        }
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(new Date());
        }
        if (bookingFile.getCustomerProfile() == null) {
            bookingFile.setCustomerProfile(parameters.getClient());
        }
        if (bookingFile.getReservations().isEmpty()) {
            Reservation reservation2 = new Reservation();
            BookingHelper.addReservation((BookingFile)bookingFile, (Reservation)reservation2);
            reservations = Stream.of(reservation2);
        } else {
            reservations = bookingFile.getReservations().stream();
        }
        reservations.forEach(reservation -> {
            reservation.setBookingAgent(agentData.getAgent());
            reservation.setResDate(new Date());
            if (reservation.getSalesPoint() == null) {
                reservation.setSalesPoint(agentData.getSalesPoint());
            }
            if (reservation.getSubagency() == null) {
                reservation.setSubagency(agentData.getSubagency());
            }
        });
        if (uiData.getSubagency() == null) {
            uiData.setSubagency(agentData.getSubagency());
        }
    }

    @Override
    public void onCreateEnd(BookingFile bookingFile, BookingFileUIData uiData, BookingFileCreateParametersPaneVM parameters) {
    }
}

