/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.custom.metadata.MetadataValueHolder;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.metadata.uidata.MetadataUIData;
import com.gridnine.xtrip.common.model.system.BaseMetadata;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class VMHelper {
    public static <T extends BaseEntity> void copy(T source, T target) {
        try {
            XCloneModelHelper.copy(source == null ? (BaseEntity)target.getClass().newInstance() : source, target);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public static <T> void transfer(Collection<? extends T> src, Collection<T> dest) {
        dest.clear();
        dest.addAll(src);
    }

    public static <S, D> void transfer(Collection<S> src, Collection<D> dest, Function<S, D> converter) {
        dest.clear();
        if (src.isEmpty()) {
            return;
        }
        src.forEach(item -> {
            Object converted = converter.apply(item);
            if (converted != null) {
                dest.add(converted);
            }
        });
    }

    public static <S extends Identity, D extends Identity> void transfer(Collection<S> src, Collection<D> dest, Function<S, D> instanceSupplier, BiConsumer<S, D> translator) {
        if (src.isEmpty()) {
            dest.clear();
            return;
        }
        ArrayList<Identity> result = new ArrayList<Identity>(src.size());
        for (Identity srcItem : src) {
            if (srcItem == null) continue;
            Identity destItem = null;
            Iterator<D> it = dest.iterator();
            while (it.hasNext()) {
                Identity mdl = (Identity)it.next();
                if (!MiscUtil.equals((Object)srcItem.getUid(), (Object)mdl.getUid())) continue;
                it.remove();
                destItem = mdl;
                break;
            }
            if (destItem == null) {
                destItem = (Identity)instanceSupplier.apply(srcItem);
                destItem.setUid(srcItem.getUid());
                if (destItem.getUid() == null) {
                    destItem.setUid(UUIDGenerator.generate().toString());
                    srcItem.setUid(destItem.getUid());
                }
            }
            translator.accept(srcItem, destItem);
            result.add(destItem);
        }
        dest.clear();
        dest.addAll(result);
    }

    public static <VM extends Identity, M extends Identity> void transfer(Collection<VM> src, Collection<M> dest, Predicate<M> destFilter, Function<VM, M> instanceSupplier, BiConsumer<VM, M> translator) {
        ArrayList<Identity> list = new ArrayList<Identity>();
        Iterator<M> it = dest.iterator();
        while (it.hasNext()) {
            Identity item = (Identity)it.next();
            if (!destFilter.test(item)) continue;
            list.add(item);
            it.remove();
        }
        VMHelper.transfer(src, list, instanceSupplier, translator);
        dest.addAll(list);
    }

    public static void fromVM(L10nString src, L10nString dest) {
        if (src == dest) {
            return;
        }
        dest.getValues().clear();
        if (src != null) {
            dest.getValues().putAll(src.getValues());
        }
    }

    public static Optional<Metadata> getMetdata(List<Metadata> list, MetadataKey key) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        for (Metadata md : list) {
            DictionaryReference mdKey = md.getKey();
            if (mdKey == null || !key.name().equals(mdKey.getCode())) continue;
            return Optional.of(md);
        }
        return Optional.empty();
    }

    public static Optional<Metadata> getMetdata(List<Metadata> list, String key) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        for (Metadata md : list) {
            DictionaryReference mdKey = md.getKey();
            if (mdKey == null || !key.equals(mdKey.getCode())) continue;
            return Optional.of(md);
        }
        return Optional.empty();
    }

    public static Optional<Metadata> setMetadata(List<Metadata> list, MetadataKey key, Object value) {
        Metadata data = null;
        boolean remove = value instanceof String ? TextUtil.isBlank((String)((String)value)) : value == null;
        Iterator<Metadata> it = list.iterator();
        while (it.hasNext()) {
            Metadata md = it.next();
            DictionaryReference ref = md.getKey();
            if (ref == null || !key.name().equals(ref.getCode())) continue;
            if (remove) {
                it.remove();
                break;
            }
            data = md;
            break;
        }
        if (data == null) {
            if (remove) {
                return Optional.empty();
            }
            data = new Metadata();
            data.setKey((DictionaryReference)new MetadataKeyDescriptorReference(key.name()));
            list.add(data);
        }
        data.setValue(value);
        return Optional.of(data);
    }

    public static Optional<Metadata> setMetadata(List<Metadata> list, String key, Object value) {
        Metadata data = null;
        boolean remove = value instanceof String ? TextUtil.isBlank((String)((String)value)) : value == null;
        Iterator<Metadata> it = list.iterator();
        while (it.hasNext()) {
            Metadata md = it.next();
            DictionaryReference ref = md.getKey();
            if (ref == null || !key.equals(ref.getCode())) continue;
            if (remove) {
                it.remove();
                break;
            }
            data = md;
            break;
        }
        if (data == null) {
            if (remove) {
                return Optional.empty();
            }
            data = new Metadata();
            data.setKey((DictionaryReference)new MetadataKeyDescriptorReference(key));
            list.add(data);
        }
        data.setValue(value);
        return Optional.of(data);
    }

    public static void metadataToVM(List<MetadataUIData> uiDataList, List<? extends BaseMetadata> model, List<MetadataValueHolder> vm) {
        Map holderMap = uiDataList.stream().filter(uiData -> !uiData.isPredefined()).map(uiData -> {
            MetadataValueHolder holder = new MetadataValueHolder();
            holder.setKey(uiData.getMetadata());
            holder.setCaption(uiData.getCaption());
            holder.setValueType(uiData.getValueType().name());
            return holder;
        }).collect(Collectors.toMap(MetadataValueHolder::getKey, Function.identity()));
        if (!holderMap.isEmpty()) {
            model.forEach(metadata -> Optional.ofNullable(holderMap.get(metadata.getKey())).ifPresent(holder -> holder.setValue(metadata.getValue())));
        }
        vm.clear();
        vm.addAll(holderMap.values());
    }

    public static <M extends BaseMetadata> void metadataFromVM(List<MetadataUIData> uiDataList, List<M> model, List<MetadataValueHolder> vm, Supplier<M> metadataSupplier) {
        ArrayList result = new ArrayList();
        if (!model.isEmpty()) {
            Set metadataToKeep = uiDataList.stream().filter(MetadataUIData::isPredefined).map(MetadataUIData::getMetadata).collect(Collectors.toSet());
            result.addAll(model.stream().filter(metadata -> metadataToKeep.contains(metadata.getKey())).collect(Collectors.toList()));
        }
        vm.stream().filter(valueHolder -> valueHolder.getValue() != null).forEach(valueHolder -> {
            BaseMetadata metadata = (BaseMetadata)metadataSupplier.get();
            metadata.setKey(valueHolder.getKey());
            metadata.setValue(valueHolder.getValue());
            result.add(metadata);
        });
        model.clear();
        model.addAll(result);
    }

    private VMHelper() {
    }
}

