/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.home;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.home.ImageViewPane;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class HomePane
extends StackPane {
    private static final String[] PHOTOS = new String[]{"pexels-photo-115047.jpeg", "pexels-photo-132982.jpeg", "pexels-photo-164646.jpeg", "pexels-photo-196464.jpeg", "pexels-photo-298872.jpeg", "pexels-photo-346885.jpeg", "pexels-photo-59519.jpeg"};
    private ScheduledFuture<?> scheduledFuture;
    private int imageIdx = new Random().nextInt(PHOTOS.length);

    public HomePane() {
        super(new Node[]{new Region()});
        this.setOnMouseClicked(evt -> this.changeImage());
        this.changeImage();
    }

    private void changeImage() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        FadeTransition transition1 = new FadeTransition(Duration.millis((double)400.0), (Node)this.getChildren().get(0));
        transition1.setToValue(0.0);
        transition1.setOnFinished(evt -> {
            ++this.imageIdx;
            if (this.imageIdx >= PHOTOS.length) {
                this.imageIdx = 0;
            }
            ImageView imageView = new ImageView(new Image(((Object)((Object)this)).getClass().getResource(PHOTOS[this.imageIdx]).toExternalForm(), true));
            imageView.setPreserveRatio(true);
            this.getChildren().setAll((Object[])new Node[]{new ImageViewPane(imageView)});
            FadeTransition transition2 = new FadeTransition(Duration.millis((double)800.0), (Node)imageView);
            transition2.setToValue(1.0);
            transition2.setOnFinished(evt2 -> {
                imageView.setOpacity(1.0);
                this.scheduledFuture = Notifications.get().getScheduler().schedule(() -> {
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(true);
                        this.scheduledFuture = null;
                    }
                    FxUtil.submitToFxThread(this::changeImage);
                }, 30L, TimeUnit.SECONDS);
            });
            transition2.play();
        });
        transition1.play();
    }
}

