/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtAction;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.rpc.TaskService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public class CreateTaskAction
implements LrtAction {
    public String getId() {
        return "lrt-create-task";
    }

    public ActionIcon getIcon(AssetsListPane context) {
        return StandardActionIcons.ADD;
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isAvailable(AssetsListPane context) {
        return context.getAssetHandler().getAssetType().equals(LongRunningTaskInfo.class);
    }

    public boolean isEnabled(AssetsListPane context) {
        return true;
    }

    public void execute(Control source, AssetsListPane context, boolean alt) {
        ArrayList items = new ArrayList(ClientRegistry.get().allOf(LrtHandler.TYPE).values().stream().filter(item -> item.canCreateTask()).sorted(LrtHandler.COMPARATOR).collect(Collectors.toList()));
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> items);
        widget.setConverter(new StringConverter<LrtHandler<?>>(){

            public String toString(LrtHandler<?> object) {
                return object.getName();
            }

            public LrtHandler<?> fromString(String string) {
                return null;
            }
        });
        widget.setSortItems(false);
        widget.setNoNulls(true);
        if (!items.isEmpty()) {
            widget.setValue(items.get(0));
        }
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(Messages.Choose_task_type).setBody((Node)widget).setActionCaption(Messages.Choose).setActionHandler(() -> this.showConfigurator(context, (LrtHandler)widget.getValue())).show((Region)source);
    }

    private <C extends Node> void showConfigurator(AssetsListPane context, LrtHandler<C> handler) {
        Object configurator = handler.createConfigurator();
        DateTimeValueWidget dateWidget = new DateTimeValueWidget(false);
        TextFieldWidget instanceWidget = new TextFieldWidget(false);
        GridContainer ctr = new GridContainer(2);
        GridCell startDateCell = new GridCell(Messages.Start_date_time, (Node)dateWidget);
        startDateCell.setHelp(() -> new QuickHelp(Messages.Start_date_time_help));
        ctr.getCells().addAll((Object[])new GridCell[]{startDateCell, new GridCell(Messages.Node, (Node)instanceWidget)});
        Dialog dialog = new Dialog().setTitle(handler.getName());
        if (configurator == null) {
            dialog.setBody((Node)ctr);
        } else {
            CardsContainer cc = new CardsContainer();
            cc.getCards().addAll((Object[])new Card[]{new Card("launchParameters", UiCardsContainer.Style.STATIC, Messages.Start_parameters, (Node)ctr), new Card("taskParameters", UiCardsContainer.Style.STATIC, Messages.Task_parameters, configurator)});
            dialog.setBody((Node)cc).setExpandToParent(!handler.isCompactConfigurator());
        }
        dialog.addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Plan_task, () -> this.scheduleTask(handler, dateWidget, instanceWidget, configurator), handler.createAvailability(configurator)).show((Node)context);
    }

    private <C extends Node> void scheduleTask(LrtHandler<C> handler, DateTimeValueWidget dateWidget, TextFieldWidget instanceWidget, C configurator) {
        LocalDateTime date = dateWidget.getValue();
        String instance = instanceWidget.getValue();
        Serializable configuration = handler.getConfiguration(configurator);
        Notifications.get().submitTask(() -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            TaskService taskService = (TaskService)RpcServiceManager.get().getService(TaskService.class);
            LongRunningTaskInfo taskInfo = taskService.addTask(sic, handler.getTaskClassName(), DateUtils.asDate((LocalDateTime)date), instance, configuration);
            EventBus.get().publishAsync((Event)new AssetModificationEvent(new AssetModification[]{new AssetModification((BaseAsset)taskInfo, AssetModification.ModificationType.CHANGE)}));
        }, Messages.Creating_task);
    }

    public AclQuery getACLQuery(AssetsListPane context) {
        return null;
    }
}

