/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtAction;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.rpc.TaskService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class DeleteTaskAction
implements LrtAction {
    public String getId() {
        return "lrt-delete-task";
    }

    public ActionIcon getIcon(AssetsListPane context) {
        return StandardActionIcons.DELETE;
    }

    public double getWeight() {
        return 40.0;
    }

    public boolean isAvailable(AssetsListPane context) {
        return context.getAssetHandler().getAssetType().equals(LongRunningTaskInfo.class);
    }

    public boolean isEnabled(AssetsListPane context) {
        if (context.getSelectedItems().isEmpty()) {
            return false;
        }
        for (BaseAsset item : context.getSelectedItems()) {
            LongRunningTaskInfo info;
            if (item == null || (info = (LongRunningTaskInfo)item).getState() != LongRunningTaskInfo.State.RUNNING) continue;
            return false;
        }
        return true;
    }

    public void execute(Control source, AssetsListPane context, boolean alt) {
        HashSet<String> taskUids = new HashSet<String>();
        for (BaseAsset item : context.getSelectedItems()) {
            LongRunningTaskInfo info = (LongRunningTaskInfo)item;
            if (info.getState() == LongRunningTaskInfo.State.RUNNING) continue;
            taskUids.add(info.getUid());
        }
        if (taskUids.isEmpty()) {
            return;
        }
        Dialog.confirm((Node)context, (String)Messages.Delete_selected_tasks, null, (String)Messages.Delete, () -> Notifications.get().submitTask(() -> this.doDelete(taskUids), context.getMutex()), null);
    }

    private void doDelete(Set<String> taskUids) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        TaskService taskService = (TaskService)RpcServiceManager.get().getService(TaskService.class);
        for (String uid2 : taskUids) {
            taskService.deleteTask(sic, uid2);
        }
        EventBus.get().publishAsync((Event)new AssetModificationEvent((Collection)taskUids.stream().map(uid -> new AssetModification((BaseAsset)new LongRunningTaskInfo(uid), AssetModification.ModificationType.DELETE)).collect(Collectors.toList())));
    }
}

