/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.tasks.CheckDuplicateIndexEntryTaskConfiguration;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class CheckDuplicateIndexEntryTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "CheckDuplicateIndexEntryTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.CheckDuplicateIndexEntryTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    public static final class DataItem<T> {
        private final String displayName;
        private final T data;

        public DataItem(String displayNameValue, T dataValue) {
            this.displayName = displayNameValue;
            this.data = dataValue;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public T getData() {
            return this.data;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    static final class Configurator
    extends GridContainer {
        private final BooleanValueWidget stopOnError = new BooleanValueWidget(true, false);
        private final BooleanValueWidget recover;
        private final BooleanValueWidget repairTypes;
        private final MultiComboBoxWidget<DataItem<String>> selectedClasses;

        public Configurator() {
            this.stopOnError.setValue(true);
            this.recover = new BooleanValueWidget(true, false);
            this.recover.setValue(true);
            this.repairTypes = new BooleanValueWidget(true, false);
            this.repairTypes.setValue(false);
            MetaRegistry metaRegistry = (MetaRegistry)Environment.getPublished(MetaRegistry.class);
            this.selectedClasses = new MultiComboBoxWidget(false);
            this.selectedClasses.setItemsSupplier(() -> metaRegistry.getIndexes().values().stream().filter((? super T value) -> this.filter(value.getId())).map(value -> new DataItem<String>(value.getDisplayName(), value.getId())).sorted((o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString())).collect(Collectors.toList()), false);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.CheckDuplicateIndexEntryTask_stopAfterFirstError, (Node)this.stopOnError), new GridCell(Messages.CheckDuplicateIndexEntryTask_automaticRecovery, (Node)this.recover), new GridCell(Messages.CheckDuplicateIndexEntryTask_recoverDataFromTheList, (Node)this.repairTypes), new GridCell("\u0414\u0430\u043d\u043d\u044b\u0435", this.selectedClasses)});
        }

        private boolean filter(String id) {
            return MiscUtil.equals((Object)id, (Object)"com.gridnine.xtrip.common.model.profile.PersonIndex") || MiscUtil.equals((Object)id, (Object)"com.gridnine.xtrip.common.model.profile.OrganizationIndex");
        }

        public CheckDuplicateIndexEntryTaskConfiguration createConfiguration() {
            CheckDuplicateIndexEntryTaskConfiguration result = new CheckDuplicateIndexEntryTaskConfiguration();
            result.setStopOnError(this.stopOnError.getValue());
            result.setRecover(this.recover.getValue());
            if (this.repairTypes.getValue()) {
                ObservableList values = this.selectedClasses.getValues();
                values.stream().map(DataItem::getData).forEach(data -> result.getTypeList().add(data));
            }
            return result;
        }
    }
}

