/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.tasks.CopyLocaleToLocaleTaskConfiguration;
import com.gridnine.xtrip.common.util.LocaleUtil;
import java.io.Serializable;
import java.util.Locale;
import javafx.util.StringConverter;

public class CopyDictionaryFromLocaleToLocaleTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "CopyDictionaryFromLocaleToLocaleTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.CopyDictionaryFromLocaleToLocaleTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final ComboBoxWidget<Locale> fromWidget = new ComboBoxWidget(false);
        private final ComboBoxWidget<Locale> toWidget = new ComboBoxWidget(false);

        Configurator() {
            super(4);
            this.fromWidget.setItemsSupplier(LocaleUtil::getAvailableLocales);
            this.fromWidget.setConverter(this.createConverter());
            this.fromWidget.setNoNulls(true);
            this.toWidget.setItemsSupplier(LocaleUtil::getAvailableLocales);
            this.toWidget.setConverter(this.createConverter());
            this.toWidget.setNoNulls(true);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.From_locale, this.fromWidget), new GridCell(Messages.In_locale, this.toWidget)});
        }

        CopyLocaleToLocaleTaskConfiguration createConfiguration() {
            CopyLocaleToLocaleTaskConfiguration result = new CopyLocaleToLocaleTaskConfiguration();
            result.setLocaleFrom((Locale)this.fromWidget.getValue());
            result.setLocaleTo((Locale)this.toWidget.getValue());
            return result;
        }

        private StringConverter<Locale> createConverter() {
            return new StringConverter<Locale>(){

                public String toString(Locale object) {
                    return object.getDisplayLanguage();
                }

                public Locale fromString(String string) {
                    return null;
                }
            };
        }
    }
}

