/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.DeleteBookingFileRelatedObjectsTaskConfiguration;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;

public class DeleteBookingFileRelatedObjectsTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "DeleteBookingFileRelatedObjectsTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.cleanup.DeleteBookingFileRelatedObjectsTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final IntValueWidget threadCount = new IntValueWidget(false);
        private final BasicRestrictionsWidget criterions = new BasicRestrictionsWidget(false);

        Configurator() {
            super(4);
            this.threadCount.setDefaultValue((Number)1);
            this.criterions.setRestrictionId(BookingFileIndex.class.getName());
            GridCell critCell = new GridCell(Messages.Criteria, (Node)this.criterions);
            critCell.setColSpan(Integer.MAX_VALUE);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.ThreadCount, (Node)this.threadCount), GridCell.NEW_ROW_MARKER, critCell});
        }

        DeleteBookingFileRelatedObjectsTaskConfiguration createConfiguration() {
            DeleteBookingFileRelatedObjectsTaskConfiguration result = new DeleteBookingFileRelatedObjectsTaskConfiguration();
            result.setThreadCount(((Integer)this.threadCount.getValue()).intValue());
            RestrictionsData rd = new RestrictionsData();
            this.criterions.writeData(rd);
            try {
                Class<?> indexClass = Class.forName(rd.getRestrictionId());
                result.getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)rd.getRestrictions(), indexClass, Collections.emptyList()));
            }
            catch (ClassNotFoundException e) {
                ErrorHandler.handle((Throwable)e);
            }
            return result;
        }
    }
}

