/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.tasks.ExecuteGroovyScriptTaskConfiguration;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javafx.scene.Node;

public class ExecuteGroovyScriptTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ExecuteGroovyScriptTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.ExecuteGroovyScriptTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator(false);
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    @Override
    public Configurator getReadOnlyConfigurator(XSerializable configuration) {
        Configurator configurator = new Configurator(true);
        configurator.readConfiguration((ExecuteGroovyScriptTaskConfiguration)configuration);
        return configurator;
    }

    static final class Configurator
    extends GridContainer {
        private final TextAreaWidget scriptWidget = new TextAreaWidget(false);
        private final FileChooserWidget inputFileWidget = new FileChooserWidget(false);

        Configurator(boolean readonly) {
            super(4);
            this.inputFileWidget.setMode(FileChooserWidget.ChoosingMode.OPEN_SINGLE);
            GridCell inputFileWidgetGridCell = new GridCell(Messages.Script_working_file, (Node)this.inputFileWidget);
            inputFileWidgetGridCell.setColSpan(Integer.MAX_VALUE);
            this.getCells().add((Object)inputFileWidgetGridCell);
            GridCell textAreaWidgetGridCell = new GridCell(Messages.Script_text, (Node)this.scriptWidget);
            textAreaWidgetGridCell.setColSpan(Integer.MAX_VALUE);
            this.getCells().add((Object)textAreaWidgetGridCell);
            this.scriptWidget.getViewState().setReadonly(readonly);
            this.inputFileWidget.getViewState().setReadonly(readonly);
        }

        ExecuteGroovyScriptTaskConfiguration createConfiguration() {
            ExecuteGroovyScriptTaskConfiguration result = new ExecuteGroovyScriptTaskConfiguration();
            result.setScript(this.scriptWidget.getValue());
            File inputFile = (File)CollectionUtil.head((Iterable)this.inputFileWidget.getFiles());
            if (Objects.nonNull(inputFile)) {
                result.setInputFileName(inputFile.getName());
                try {
                    result.setInputFileBody(IoUtil.readFileToByteArray((File)inputFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        void readConfiguration(ExecuteGroovyScriptTaskConfiguration configuration) {
            this.scriptWidget.setValue(configuration.getScript());
            if (TextUtil.nonBlank((String)configuration.getInputFileName())) {
                this.inputFileWidget.getFiles().add((Object)new File(configuration.getInputFileName()));
            }
        }
    }
}

