/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.dict.ScriptVariants;
import com.gridnine.xtrip.common.model.tasks.MassCreatingTransactionsTaskConfiguration;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javafx.scene.Node;
import org.apache.commons.io.IOUtils;

public class MassCreatingTransactionsTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "MassCreatingTransactionsTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.MassCreatingTransactionsTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    @Override
    public boolean isCompactConfigurator() {
        return true;
    }

    private static String getScriptText(ScriptVariants variant) {
        String scriptText;
        String fileName = "data/";
        switch (variant) {
            case INN_SCRIPT: {
                fileName = fileName + "ScriptBodyINN.txt";
                break;
            }
            case CODE_SCRIPT: {
                fileName = fileName + "ScriptBodyCode.txt";
            }
        }
        try {
            InputStream inputStream = MassCreatingTransactionsTaskHandler.class.getResourceAsStream(fileName);
            scriptText = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException e) {
            scriptText = "Error while reading script text from file. Please contact developer.";
        }
        return scriptText;
    }

    static final class Configurator
    extends GridContainer {
        private final ComboBoxWidget<ScriptVariants> scriptWidget = new ComboBoxWidget(false);
        private final FileChooserWidget inputFileWidget = new FileChooserWidget(false);

        Configurator() {
            super(2);
            this.inputFileWidget.setMode(FileChooserWidget.ChoosingMode.OPEN_SINGLE);
            GridCell inputFileWidgetGridCell = new GridCell(Messages.Script_working_file, (Node)this.inputFileWidget);
            inputFileWidgetGridCell.setColSpan(2);
            this.getCells().add((Object)inputFileWidgetGridCell);
            this.scriptWidget.setNoNulls(true);
            this.scriptWidget.setItemsSupplier(() -> Arrays.asList(ScriptVariants.CODE_SCRIPT, ScriptVariants.INN_SCRIPT));
            this.scriptWidget.valueProperty().setValue((Object)ScriptVariants.INN_SCRIPT);
            GridCell variantWidgetGridCell = new GridCell(Messages.Parameters, this.scriptWidget);
            variantWidgetGridCell.setColSpan(1);
            this.getCells().add((Object)variantWidgetGridCell);
        }

        MassCreatingTransactionsTaskConfiguration createConfiguration() {
            MassCreatingTransactionsTaskConfiguration result = new MassCreatingTransactionsTaskConfiguration();
            String scriptText = MassCreatingTransactionsTaskHandler.getScriptText((ScriptVariants)this.scriptWidget.getValue());
            result.setScript(scriptText);
            File inputFile = (File)CollectionUtil.head((Iterable)this.inputFileWidget.getFiles());
            if (Objects.nonNull(inputFile)) {
                result.setInputFileName(inputFile.getName());
                try {
                    result.setInputFileBody(IoUtil.readFileToByteArray((File)inputFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }
    }
}

