/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.tasks.MigrateCostCodeValuesTaskConfiguration;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

public class MigrateCostCodeValuesTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "MigrateCostCodeValuesTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.MigrateCostCodeValuesTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public BooleanExpression createAvailability(Configurator configurator) {
        return configurator.createAvailability();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        protected final EntityBoxWidget<Organization> clientWidget = new EntityBoxWidget(Organization.class, false);
        protected final DictBoxWidget<CostCodeCategory> categoryWidget;
        protected final TextFieldWidget oldValueWidget;
        protected final TextFieldWidget newValueWidget;
        protected final TextFieldWidget oldLocalWidget;
        protected final TextFieldWidget newLocalWidget;
        protected final TextFieldWidget oldEnglishWidget;
        protected final TextFieldWidget newEnglishWidget;
        protected final DateValueWidget dateStartWidget;
        protected final DateValueWidget dateEndWidget;

        Configurator() {
            super(2);
            this.clientWidget.setFieldName(Messages.Client);
            this.clientWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
            this.categoryWidget = new DictBoxWidget(CostCodeCategory.class, false);
            this.categoryWidget.setFieldName(Messages.CostCodeCategory);
            this.dateStartWidget = new DateValueWidget(false);
            this.dateEndWidget = new DateValueWidget(false);
            this.dateEndWidget.setValue(LocalDate.now());
            this.oldValueWidget = new TextFieldWidget(false);
            this.newValueWidget = new TextFieldWidget(false);
            this.oldLocalWidget = new TextFieldWidget(false);
            this.newLocalWidget = new TextFieldWidget(false);
            this.oldEnglishWidget = new TextFieldWidget(false);
            this.newEnglishWidget = new TextFieldWidget(false);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Client, this.clientWidget), new GridCell(Messages.CostCodeCategory, this.categoryWidget), new GridCell(Messages.Start_period, (Node)this.dateStartWidget), new GridCell(Messages.End_period, (Node)this.dateEndWidget), new GridCell(Messages.OldCostCodeValue, (Node)this.oldValueWidget), new GridCell(Messages.NewCostCodeValue, (Node)this.newValueWidget), new GridCell(Messages.OldCostCodeLocalValue, (Node)this.oldLocalWidget), new GridCell(Messages.NewCostCodeLocalValue, (Node)this.newLocalWidget), new GridCell(Messages.OldCostCodeEnglishValue, (Node)this.oldEnglishWidget), new GridCell(Messages.NewCostCodeEnglishValue, (Node)this.newEnglishWidget)});
        }

        BooleanExpression createAvailability() {
            return new BooleanBinding(){
                {
                    this.bind(new Observable[]{clientWidget.valueProperty(), categoryWidget.valueProperty(), dateStartWidget.valueProperty(), dateEndWidget.valueProperty(), oldValueWidget.valueProperty(), newValueWidget.valueProperty(), oldLocalWidget.valueProperty(), newLocalWidget.valueProperty(), oldEnglishWidget.valueProperty(), newEnglishWidget.valueProperty()});
                }

                protected boolean computeValue() {
                    return clientWidget.getValue() != null && categoryWidget.getValue() != null && dateStartWidget.getValue() != null && dateEndWidget.getValue() != null && (TextUtil.nonBlank((String)oldValueWidget.getValue()) && TextUtil.nonBlank((String)newValueWidget.getValue()) || TextUtil.nonBlank((String)oldLocalWidget.getValue()) && TextUtil.nonBlank((String)newLocalWidget.getValue()) || TextUtil.nonBlank((String)oldEnglishWidget.getValue()) && TextUtil.nonBlank((String)newEnglishWidget.getValue()));
                }
            };
        }

        MigrateCostCodeValuesTaskConfiguration createConfiguration() {
            MigrateCostCodeValuesTaskConfiguration result = new MigrateCostCodeValuesTaskConfiguration();
            result.setClient(this.clientWidget.getValue());
            result.setCategory(this.categoryWidget.getValue());
            result.setIssueDateStart(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)this.dateStartWidget.getValue())));
            result.setIssueDateEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)this.dateEndWidget.getValue())));
            result.setOldValue(this.oldValueWidget.getValue());
            result.setNewValue(this.newValueWidget.getValue());
            result.setOldLocalValue(this.oldLocalWidget.getValue());
            result.setNewLocalValue(this.newLocalWidget.getValue());
            result.setOldEnglishValue(this.oldEnglishWidget.getValue());
            result.setNewEnglishValue(this.newEnglishWidget.getValue());
            return result;
        }
    }
}

