/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.system.migration.MigrationTaskConfiguration;
import java.io.Serializable;
import java.time.LocalDate;
import javafx.scene.Node;

public class MigrationTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "MigrationLongRunningTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.rest.migration.MigrationLongRunningTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final IntValueWidget threadsCount = new IntValueWidget(false);
        private final IntValueWidget batchSize = new IntValueWidget(false);
        private final BooleanValueWidget secondPass = new BooleanValueWidget(true, false);
        private final TextFieldWidget url = new TextFieldWidget(false);
        private final TextFieldWidget login = new TextFieldWidget(false);
        private final TextFieldWidget password = new TextFieldWidget(false);
        private final DateValueWidget startDate = new DateValueWidget(false);

        Configurator() {
            super(4);
            this.threadsCount.setValue((Number)4);
            this.threadsCount.setDefaultValue((Number)4);
            this.url.setValue("http://address:9090");
            this.batchSize.setValue((Number)10);
            this.batchSize.setDefaultValue((Number)10);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell("\u0410\u0434\u0440\u0435\u0441 \u041c\u041e\u041c", (Node)this.url), new GridCell("\u041b\u043e\u0433\u0438\u043d", (Node)this.login), new GridCell("\u041f\u0430\u0440\u043e\u043b\u044c", (Node)this.password), new GridCell(Messages.Threads_count, (Node)this.threadsCount), new GridCell("\u0420\u0430\u0437\u043c\u0435\u0440 \u043f\u0430\u0447\u043a\u0438", (Node)this.batchSize), new GridCell("\u0412\u0442\u043e\u0440\u043e\u0439 \u043f\u0440\u043e\u0445\u043e\u0434", (Node)this.secondPass), new GridCell("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430", (Node)this.startDate)});
        }

        MigrationTaskConfiguration createConfiguration() {
            MigrationTaskConfiguration result = new MigrationTaskConfiguration();
            result.setLogin(this.login.getValue());
            result.setUrl(this.url.getValue());
            result.setPassword(this.password.getValue());
            result.setSecondPass(this.secondPass.getValue());
            result.setStartDate(DateUtils.asDate((LocalDate)this.startDate.getValue()));
            result.setBatchSize((Integer)this.batchSize.getValue());
            result.setThreadsCount((Integer)this.threadsCount.getValue());
            return result;
        }
    }
}

