/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.tasks.ReindexLogicalStorageTaskConfiguration;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class ReindexLogicalStorageTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ReindexLogicalStorageTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.ReindexLogicalStorageTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final DateValueWidget dateValueWidget = new DateValueWidget(false);
        private final IntValueWidget hourIntevalWidget = new IntValueWidget(false);
        private final IntValueWidget threadCountWidget = new IntValueWidget(false);
        private final CheckBoxWidget useCreationDate = new CheckBoxWidget(false);
        private final CheckBoxWidget descOrder = new CheckBoxWidget(false);
        private final CheckBoxWidget stopOnError = new CheckBoxWidget(false);
        private final ValuesWidget<EntityType> entityTypeValuesWidget = this.createEntityTypesWidget();
        private final ComboBoxWidget<IndexType> onlyIndexBox = new ComboBoxWidget(false);
        private final GridCell<ComboBoxWidget<IndexType>> onlyIndexBoxCell;

        Configurator() {
            super(3);
            ArrayList<Object> cells = new ArrayList<Object>();
            cells.add(new GridCell(Messages.Date, (Node)this.dateValueWidget));
            cells.add(new GridCell(Messages.Hours_interval, (Node)this.hourIntevalWidget));
            cells.add(new GridCell(Messages.Threads_amount, (Node)this.threadCountWidget));
            cells.add(GridCell.NEW_ROW_MARKER);
            cells.add(new GridCell((Node)this.useCreationDate));
            cells.add(new GridCell((Node)this.descOrder));
            cells.add(new GridCell((Node)this.stopOnError));
            cells.add(GridCell.NEW_ROW_MARKER);
            GridCell cell = new GridCell(Messages.Restore_data_from_list, this.entityTypeValuesWidget);
            cell.setColSpan(Integer.MAX_VALUE);
            cells.add(cell);
            this.onlyIndexBoxCell = new GridCell(Messages.Restore_index_only, this.onlyIndexBox);
            this.onlyIndexBoxCell.setHidden(true);
            this.onlyIndexBoxCell.setColSpan(2);
            cells.add(this.onlyIndexBoxCell);
            this.getCells().addAll(cells);
            this.threadCountWidget.setDefaultValue((Number)1);
            this.useCreationDate.setText(Messages.Use_create_date);
            this.useCreationDate.setSelected(true);
            this.descOrder.setText(Messages.Reverse_order);
            this.descOrder.setSelected(true);
            this.stopOnError.setText(Messages.Stop_at_error);
            this.stopOnError.setSelected(true);
            this.onlyIndexBox.setLive(true);
            this.onlyIndexBox.setConverter((StringConverter)new StringConverter<IndexType>(){

                public String toString(IndexType object) {
                    return object.getDisplayName();
                }

                public IndexType fromString(String string) {
                    return null;
                }
            });
            this.entityTypeValuesWidget.getValues().addListener(o -> {
                this.onlyIndexBox.setValue(null);
                if (this.entityTypeValuesWidget.getValues().size() != 1) {
                    this.onlyIndexBoxCell.setHidden(true);
                    return;
                }
                ArrayList indexList = new ArrayList(MetaRegistryHelper.getIndexes((EntityType)((EntityType)this.entityTypeValuesWidget.getValues().get(0))));
                if (indexList.size() <= 1) {
                    this.onlyIndexBoxCell.setHidden(true);
                } else {
                    this.onlyIndexBoxCell.setHidden(false);
                    this.onlyIndexBox.setItemsSupplier(() -> indexList);
                }
            });
        }

        ReindexLogicalStorageTaskConfiguration createConfiguration() {
            ReindexLogicalStorageTaskConfiguration result = new ReindexLogicalStorageTaskConfiguration();
            result.setDate(DateUtils.asDate((LocalDate)this.dateValueWidget.getValue()));
            if (this.hourIntevalWidget.getValue() != null) {
                result.setHours(((Integer)this.hourIntevalWidget.getValue()).intValue());
            }
            if (this.threadCountWidget.getValue() != null) {
                result.setThreadCount(((Integer)this.threadCountWidget.getValue()).intValue());
            }
            result.setUsedCreateDate(this.useCreationDate.isSelected());
            result.setDescOrder(this.descOrder.isSelected());
            result.setStopOnError(this.stopOnError.isSelected());
            result.getTypeList().clear();
            if (this.onlyIndexBox.getValue() != null) {
                result.setSingleIndex(((IndexType)this.onlyIndexBox.getValue()).getId());
                result.getTypeList().add(((IndexType)this.onlyIndexBox.getValue()).getEntityId());
            } else {
                result.getTypeList().addAll(this.entityTypeValuesWidget.getValues().stream().map(BaseMetaElement::getId).collect(Collectors.toList()));
            }
            return result;
        }

        private ValuesWidget<EntityType> createEntityTypesWidget() {
            List entityTypes = MetaRegistry.get().getEntities().values().stream().filter(entityType -> MetaRegistryHelper.isRoot((EntityType)entityType) && !entityType.isAbstract() && !entityType.isHidden()).sorted((lhs, rhs) -> lhs.getDisplayName().compareTo(rhs.getDisplayName())).collect(Collectors.toList());
            ValuesWidget result = new ValuesWidget(false);
            result.setItemsSupplier(() -> entityTypes);
            result.setConverter((StringConverter)new StringConverter<EntityType>(){

                public String toString(EntityType object) {
                    String str = object.getDisplayName();
                    return TextUtil.isBlank((String)str) ? object.getId() : str;
                }

                public EntityType fromString(String string) {
                    return null;
                }
            });
            return result;
        }
    }
}

