/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.lrt.handlers.TaskHelper;
import com.gridnine.xtrip.common.model.tasks.RepairSecondaryStorageTaskConfiguration;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class RepairSecondaryStorageTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "RepairSecondaryStorageTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.RepairSecondaryStorageTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        protected final ComboBoxWidget<String> primaryStorage = new ComboBoxWidget(false);
        protected final ComboBoxWidget<String> secondaryStorage;
        protected final DateTimeValueWidget date;
        protected final IntValueWidget hours;
        protected final IntValueWidget threadCount;
        protected final BooleanValueWidget isUsedCreateDate;
        protected final BooleanValueWidget stopOnError;
        protected final BooleanValueWidget ignoreIndex;
        protected final BooleanValueWidget firstPass;
        protected final BooleanValueWidget secondPass;
        protected final BooleanValueWidget rightSecondPass;
        protected final BooleanValueWidget moveIdfsIndexes;
        protected final BooleanValueWidget repairTypes;
        protected GridContainer treePane;
        protected CustomCheckBoxTreeView<TaskHelper.Item> tree;

        Configurator() {
            super(3);
            this.primaryStorage.setAsync(true);
            this.primaryStorage.setItemsSupplier(() -> TaskHelper.createListAndConverter(this.primaryStorage));
            this.secondaryStorage = new ComboBoxWidget(false);
            this.secondaryStorage.setAsync(true);
            this.secondaryStorage.setItemsSupplier(() -> TaskHelper.createListAndConverter(this.secondaryStorage));
            this.date = new DateTimeValueWidget(false);
            this.hours = new IntValueWidget(false);
            this.threadCount = new IntValueWidget(false);
            this.isUsedCreateDate = new BooleanValueWidget(true, false);
            this.stopOnError = new BooleanValueWidget(true, false);
            this.ignoreIndex = new BooleanValueWidget(true, false);
            this.firstPass = new BooleanValueWidget(true, false);
            this.secondPass = new BooleanValueWidget(true, false);
            this.rightSecondPass = new BooleanValueWidget(true, false);
            this.moveIdfsIndexes = new BooleanValueWidget(true, false);
            this.repairTypes = new BooleanValueWidget(true, false);
            CustomCheckBoxTreeView<TaskHelper.Item> customTreeView = TaskHelper.createTree();
            customTreeView.setReadonly(true);
            this.treePane = GridContainer.wrap((Node)customTreeView.getTreePane());
            GridCell tableCell = new GridCell(Messages.List, (Node)this.treePane);
            tableCell.setColSpan(Integer.MAX_VALUE);
            this.tree = customTreeView;
            this.repairTypes.valueProperty().addListener((obs, oldValue, newValue) -> customTreeView.setReadonly(newValue == false));
            this.isUsedCreateDate.setValue(true);
            this.stopOnError.setValue(true);
            this.firstPass.setValue(true);
            this.secondPass.setValue(true);
            this.rightSecondPass.setValue(true);
            this.moveIdfsIndexes.setValue(false);
            this.repairTypes.setValue(false);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.PrimaryStorage, this.primaryStorage), new GridCell(Messages.SecondaryStorage, this.secondaryStorage), GridCell.NEW_ROW_MARKER, new GridCell(Messages.Date, (Node)this.date), new GridCell(Messages.Hours, (Node)this.hours), new GridCell(Messages.ThreadCount, (Node)this.threadCount), new GridCell(Messages.isUsedCreateDate, (Node)this.isUsedCreateDate), new GridCell(Messages.StopOnError2, (Node)this.stopOnError), new GridCell(Messages.IgnoreIndex, (Node)this.ignoreIndex), new GridCell(Messages.FirstPass, (Node)this.firstPass), new GridCell(Messages.SecondPass, (Node)this.secondPass), new GridCell(Messages.RightSecondPass, (Node)this.rightSecondPass), new GridCell(Messages.MoveIdfsIndexes, (Node)this.moveIdfsIndexes), GridCell.NEW_ROW_MARKER, new GridCell(Messages.RepairTypes, (Node)this.repairTypes), GridCell.NEW_ROW_MARKER, tableCell});
        }

        RepairSecondaryStorageTaskConfiguration createConfiguration() {
            RepairSecondaryStorageTaskConfiguration result = new RepairSecondaryStorageTaskConfiguration();
            result.setPrimaryStorageUid((String)this.primaryStorage.getValue());
            result.setSecondaryStorageUid((String)this.secondaryStorage.getValue());
            result.setDate(DateUtils.asDate((LocalDateTime)this.date.getValue()));
            result.setHours(this.hours.getValue() == null ? 0 : (Integer)this.hours.getValue());
            result.setThreadCount(this.threadCount.getValue() == null ? 0 : (Integer)this.threadCount.getValue());
            result.setUsedCreateDate(this.isUsedCreateDate.getValue());
            result.setStopOnError(this.stopOnError.getValue());
            result.setIgnoreIndex(this.ignoreIndex.getValue());
            result.setFirstPass(this.firstPass.getValue());
            result.setSecondPass(this.secondPass.getValue());
            result.setRightSecondPass(this.rightSecondPass.getValue());
            result.setMoveIdfsIndexes(this.moveIdfsIndexes.getValue());
            if (this.repairTypes.getValue()) {
                for (String id : this.tree.getSelectedItemsIds()) {
                    if (id.equals("root")) continue;
                    result.getTypeList().add(id);
                }
            } else {
                result.getTypeList().addAll(this.tree.getTreeView().getRoot().getChildren().stream().map(item -> ((TaskHelper.Item)item.getValue()).getId()).filter(str -> !str.equals("root")).collect(Collectors.toList()));
            }
            return result;
        }
    }
}

