/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.tasks.ResaveEntitiesTaskConfiguration;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class ResaveEntitiesTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ResaveEntitiesTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.ResaveEntitiesTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        DateValueWidget dateValueWidget = new DateValueWidget(false);
        IntValueWidget hourIntevalWidget = new IntValueWidget(false);
        IntValueWidget threadCountWidget = new IntValueWidget(false);
        CheckBoxWidget useCreationDate = new CheckBoxWidget(false);
        CheckBoxWidget descOrder = new CheckBoxWidget(false);
        CheckBoxWidget stopOnError = new CheckBoxWidget(false);
        CheckBoxWidget createNewVersion = new CheckBoxWidget(false);
        CheckBoxWidget restoreFromTheList = new CheckBoxWidget(false);
        ValuesWidget<EntityType> entityTypeValuesWidget = this.createEntityTypesWidget();
        GridCell<DateValueWidget> dateValueWidgetGridCell = new GridCell(Messages.Date, (Node)this.dateValueWidget);
        GridCell<IntValueWidget> hourIntevalWidgetGridCell = new GridCell(Messages.Hours_interval, (Node)this.hourIntevalWidget);
        GridCell<IntValueWidget> threadCountWidgetGridCell = new GridCell(Messages.Threads_amount, (Node)this.threadCountWidget);
        GridCell<CheckBoxWidget> useCreationDateGridCell = new GridCell((Node)this.useCreationDate);
        GridCell<CheckBoxWidget> descOrderGridCell = new GridCell((Node)this.descOrder);
        GridCell<CheckBoxWidget> stopOnErrorGridCell = new GridCell((Node)this.stopOnError);
        GridCell<CheckBoxWidget> createNewVersionGridCell = new GridCell((Node)this.createNewVersion);
        GridCell<ValuesWidget<EntityType>> valuesWidgetGridCell = new GridCell(this.entityTypeValuesWidget);
        GridCell<CheckBoxWidget> restoreFromTheListGridCell = new GridCell((Node)this.restoreFromTheList);

        Configurator() {
            super(4);
            this.threadCountWidget.setDefaultValue((Number)1);
            this.createNewVersion.setText(Messages.Create_new_version);
            this.useCreationDate.setText(Messages.Use_create_date);
            this.descOrder.setText(Messages.Reverse_order);
            this.stopOnError.setText(Messages.Stop_at_error);
            this.valuesWidgetGridCell.setHidden(true);
            this.valuesWidgetGridCell.setColSpan(Integer.MAX_VALUE);
            this.restoreFromTheList.setText(Messages.Restore_data_from_list);
            this.restoreFromTheList.selectedProperty().addListener((obj, o, n) -> {
                this.valuesWidgetGridCell.setHidden(n == false);
                this.entityTypeValuesWidget.getValues().clear();
            });
            this.getCells().addAll((Object[])new GridCell[]{this.dateValueWidgetGridCell, this.hourIntevalWidgetGridCell, this.threadCountWidgetGridCell, GridCell.NEW_ROW_MARKER, this.useCreationDateGridCell, this.descOrderGridCell, this.stopOnErrorGridCell, this.createNewVersionGridCell, this.restoreFromTheListGridCell, GridCell.NEW_ROW_MARKER, this.valuesWidgetGridCell, GridCell.NEW_ROW_MARKER});
        }

        ResaveEntitiesTaskConfiguration createConfiguration() {
            ResaveEntitiesTaskConfiguration result = new ResaveEntitiesTaskConfiguration();
            result.setDate(DateUtils.asDate((LocalDate)this.dateValueWidget.getValue()));
            result.setHours(this.hourIntevalWidget.getValue() != null ? (Integer)this.hourIntevalWidget.getValue() : 0);
            result.setThreadCount(((Integer)this.threadCountWidget.getValue()).intValue());
            result.setUsedCreateDate(this.useCreationDate.isSelected());
            result.setDescOrder(this.descOrder.isSelected());
            result.setStopOnError(this.stopOnError.isSelected());
            result.setCreateNewVersion(this.createNewVersion.isSelected());
            result.getTypeList().clear();
            if (this.restoreFromTheList.isSelected()) {
                result.getTypeList().addAll(this.entityTypeValuesWidget.getValues().stream().map(BaseMetaElement::getDisplayName).collect(Collectors.toList()));
            }
            return result;
        }

        private ValuesWidget<EntityType> createEntityTypesWidget() {
            List entityTypes = MetaRegistry.get().getEntities().values().stream().filter(entityType -> MetaRegistryHelper.isRoot((EntityType)entityType) && !entityType.isAbstract() && !entityType.isHidden()).sorted(Comparator.comparing(BaseMetaElement::getDisplayName)).collect(Collectors.toList());
            ValuesWidget result = new ValuesWidget(false);
            result.setItemsSupplier(() -> entityTypes);
            result.setConverter((StringConverter)new StringConverter<EntityType>(){

                public String toString(EntityType object) {
                    return object.getDisplayName();
                }

                public EntityType fromString(String string) {
                    return null;
                }
            });
            return result;
        }
    }
}

