/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.registry.basic.MainTool;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.system.DBVersionsContainer;
import com.gridnine.xtrip.client.fx.model.system.DBVersionsTableVM;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.GeneralFxService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public class DBVersionsTool
implements MainTool {
    private TableWidgetController<TableWidget<DBVersionsTableVM>, DBVersionsTableVM> tableController;

    public String getId() {
        return "main-tool-db-versions";
    }

    public double getWeight() {
        return 9999.0;
    }

    public AclQuery getACLQuery() {
        return null;
    }

    public void execute() {
        Dialog dialog = new Dialog();
        dialog.setExpandToParent(true);
        final DBVersionsContainer tableCont = new DBVersionsContainer(false);
        this.tableController = new TableWidgetController<TableWidget<DBVersionsTableVM>, DBVersionsTableVM>(){

            public TableWidget<DBVersionsTableVM> getView() {
                return (TableWidget)tableCont.getContent();
            }
        };
        dialog.setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.DBVerions_Title).addButton(DialogButtonStyle.AUXILARY, Messages.General_Close, () -> ((Dialog)dialog).close());
        Notifications.get().submitTask(() -> {
            GeneralFxService service = (GeneralFxService)RpcServiceManager.get().getService(GeneralFxService.class);
            TreeMap<String, String> dbProperties = new TreeMap<String, String>(service.getVersions(ServiceInvocationContext.get()));
            ArrayList<DBVersionsTableVM> rows = new ArrayList<DBVersionsTableVM>();
            for (String string : new HashSet(dbProperties.keySet())) {
                if (!string.startsWith("com.gridnine.xtrip.server.licence")) continue;
                dbProperties.remove(string);
            }
            dbProperties.put("git.revision", Environment.getGitRevision());
            for (Map.Entry entry : dbProperties.entrySet()) {
                DBVersionsTableVM row = new DBVersionsTableVM();
                row.setName((String)entry.getKey());
                row.setVersion((String)entry.getValue());
                rows.add(row);
            }
            FxUtil.waitForFxThread(() -> {
                dialog.addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.DBVerions_Copy_To_Clipboard, () -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, this.dbPropertiesToString(dbProperties))));
                this.tableController.readData((Collection)rows);
                dialog.setBody((Node)tableCont);
                dialog.showGlobal();
            });
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Notifications_getting_data);
    }

    private String dbPropertiesToString(Map<String, String> dbProperties) {
        StringBuilder strBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : dbProperties.entrySet()) {
            strBuilder.append(entry.getKey()).append(" - ").append(entry.getValue()).append(";").append(System.lineSeparator());
        }
        return strBuilder.toString();
    }
}

