/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportImportHelper;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportZipTask;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.stage.FileChooser;

class ExportDialog {
    ExportDialog() {
    }

    static void showDialog() {
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Export_files_MOM, new String[]{"*.zip"})));
        ItemExportSettings root = ExportImportHelper.createModelExport();
        CustomCheckBoxTreeView<ItemExportSettings> customTreeView = new CustomCheckBoxTreeView<ItemExportSettings>(root, true, Collections.emptyList()){

            protected List<ItemExportSettings> getNodeChildren(ItemExportSettings v) {
                return v.getChildren();
            }

            protected String getNodeTitle(ItemExportSettings v) {
                return ExportImportHelper.toString(v.getObjectId());
            }

            protected String getNodeId(ItemExportSettings v) {
                return v.getObjectId();
            }
        };
        customTreeView.getTreePane().setPrefWidth(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 0.6);
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("file", UiCardsContainer.Style.STATIC, Messages.File, (Node)GridContainer.wrap((Node)fileChooserWidget)));
        cardsContainer.getCards().add((Object)new Card("exportedData", UiCardsContainer.Style.STATIC, Messages.Exported_data, (Node)GridContainer.wrap((Node)customTreeView.getTreePane())));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Export_Parameters).setAutoClose(false).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Export, () -> ExportDialog.lambda$showDialog$1(fileChooserWidget, (CustomCheckBoxTreeView)customTreeView, root, dialog)).setOnCloseRequest(() -> ((Dialog)dialog).close()).showGlobal();
    }

    private static void collectSettings(List<ItemExportSettings> allSettings, ItemExportSettings item, List<String> selectedIds) {
        if (item.isGroup()) {
            for (ItemExportSettings nestedItem : item.getChildren()) {
                ExportDialog.collectSettings(allSettings, nestedItem, selectedIds);
            }
            return;
        }
        if (!selectedIds.contains(item.getObjectId())) {
            return;
        }
        ItemExportSettings settings = new ItemExportSettings();
        settings.setItemType(item.getItemType());
        settings.setObjectId(item.getObjectId());
        settings.setExportType(item.getExportType());
        switch (item.getExportType()) {
            case QUERY: {
                settings.setQueryData(item.getQueryData());
                break;
            }
            case SELECTED: {
                settings.getSelectedItems().addAll(item.getSelectedItems());
                break;
            }
            default: {
                settings.setExportType(ExportType.ALL);
            }
        }
        allSettings.add(settings);
    }

    private static /* synthetic */ void lambda$showDialog$1(FileChooserWidget fileChooserWidget, CustomCheckBoxTreeView customTreeView, ItemExportSettings root, Dialog dialog) {
        if (fileChooserWidget.getFiles().isEmpty()) {
            Dialog.info((String)Messages.No_file_selected);
        } else if (customTreeView.getSelectedItemsIds().isEmpty()) {
            Dialog.info((String)Messages.No_object_selected);
        } else {
            ArrayList<ItemExportSettings> exportSettingsList = new ArrayList<ItemExportSettings>();
            ExportDialog.collectSettings(exportSettingsList, root, customTreeView.getSelectedItemsIds());
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportZipTask((File)fileChooserWidget.getFiles().get(0), exportSettingsList));
            dialog.close();
        }
    }
}

