/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.MainTool;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalPasswordContainer;
import com.gridnine.xtrip.client.fx.fiscal.tool.CashIncomePanel;
import com.gridnine.xtrip.client.fx.fiscal.tool.CashOutcomePanel;
import com.gridnine.xtrip.client.fx.fiscal.tool.FiscalToolActionPanel;
import com.gridnine.xtrip.client.fx.fiscal.tool.FiscalToolMainPanel;
import com.gridnine.xtrip.client.fx.fiscal.tool.FiscalToolPanel;
import com.gridnine.xtrip.client.fx.standard.helpers.fiscal.FiscalReceiptHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.math.BigDecimal;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

public class FiscalTool
implements MainTool {
    public double getWeight() {
        return 1500.0;
    }

    public AclQuery getACLQuery() {
        return null;
    }

    public void execute() {
        Notifications.get().submitTask(() -> {
            FiscalToolPanel panel = new FiscalToolPanel(false);
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getOpenSessionNode().setOnAction(event -> this.openSession(panel));
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getZReportNode().setOnAction(event -> this.zReport(panel));
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getXReportNode().setOnAction(event -> this.xReport());
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getSessionReportNode().setOnAction(event -> this.sessionReport());
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getCheckOfdConnectionNode().setOnAction(event -> this.checkOfdConnection());
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getCashIncomeNode().setOnAction(event -> this.cashIncome(panel));
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getCashOutcomeNode().setOnAction(event -> this.cashOutcome(panel));
            ((FiscalToolActionPanel)panel.getActionCard().getContent()).getCashOutcomeNode().getViewState().setNotEditable(true);
            this.update(panel);
            FxUtil.waitForFxThread(() -> new Dialog().setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.CashRegisterManagement).setBody((Node)panel).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close).showGlobal());
        }, Messages.General_Data_loading);
    }

    public String getId() {
        return "main-tool-fiscal";
    }

    public boolean isAvailable() {
        return Workplace.get().isWorklogEnabled() && Workplace.get().isWorklogOpen() && ClientSettings.get().isEnabledRemoteFiscalServiceProvider();
    }

    private void xReport() {
        Notifications.get().submitTask(() -> {
            FiscalReceiptHelper.printXReport();
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.XReportPrinted, (Object[])new Object[0])});
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.PrintingXReport);
    }

    private void zReport(FiscalToolPanel fiscalToolPanel) {
        Notifications.get().submitTask(() -> {
            boolean askPassword = FiscalReceiptHelper.isCloseSessionRequirePassword();
            if (!askPassword) {
                this.closeSession();
                this.update(fiscalToolPanel);
            } else {
                FxUtil.waitForFxThread(() -> {
                    FiscalPasswordContainer fiscalPasswordContainer = new FiscalPasswordContainer(false);
                    Dialog passwordDialog = new Dialog();
                    passwordDialog.setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.CloseSessionPassword).setBody((Node)fiscalPasswordContainer).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)passwordDialog).close()).addButton(DialogButtonStyle.DECLINE, Messages.General_Close, () -> ((Dialog)passwordDialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_OK, () -> {
                        String enteredPassword = ((PasswordFieldWidget)fiscalPasswordContainer.getContent()).getValue();
                        Notifications.get().submitTask(() -> {
                            boolean passwordCorrect = FiscalReceiptHelper.checkCloseSessionPassword(enteredPassword);
                            if (passwordCorrect) {
                                FxUtil.waitForFxThread(() -> ((Dialog)passwordDialog).close());
                                this.closeSession();
                                this.update(fiscalToolPanel);
                            } else {
                                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.CloseSessionPasswordIncorrect, (Object[])new Object[0])});
                            }
                        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.PrintingZReport);
                    }).showGlobal();
                });
            }
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.PrintingZReport);
    }

    private void openSession(FiscalToolPanel fiscalToolPanel) {
        Notifications.get().submitTask(() -> {
            FiscalReceiptHelper.openSession();
            this.update(fiscalToolPanel);
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.SessionOpened, (Object[])new Object[0])});
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.OpeningSession);
    }

    private void closeSession() throws Exception {
        FiscalReceiptHelper.closeSession();
        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.ZReportPrinted, (Object[])new Object[0])});
    }

    private void sessionReport() {
        Notifications.get().submitTask(() -> {
            String kktAddress = FiscalReceiptHelper.getServerAddress();
            if (!kktAddress.startsWith("http")) {
                kktAddress = "http://" + kktAddress;
            }
            if (!kktAddress.endsWith("/")) {
                kktAddress = kktAddress + "/";
            }
            String url = String.format("%sreport.html?user=%s", kktAddress, ServiceInvocationContext.get().getUser());
            FxUtil.openUrl((String)url);
        }, Messages.General_Data_loading);
    }

    private void checkOfdConnection() {
        Notifications.get().submitTask(() -> {
            String result = FiscalReceiptHelper.checkOFDConnection();
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(com.gridnine.xtrip.client.fx.standard.l10n.Messages.CheckResult + ": " + result), (Object[])new Object[0])});
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.CheckOFDConnection);
    }

    private void cashIncome(FiscalToolPanel fiscalToolPanel) {
        Notifications.get().submitTask(() -> {
            String currency = Prefetched.getData().getEquivalentCurrency();
            BigDecimal currentCashAmount = Optional.ofNullable(FiscalReceiptHelper.getCashBoxAmount()).map(item -> BigDecimal.valueOf(item)).orElse(null);
            FxUtil.waitForFxThread(() -> {
                Dialog dialog = new Dialog();
                final CashIncomePanel panel = new CashIncomePanel(false);
                panel.getCurrentCashAmountNode().setValue(SystemHelper.getMoney((BigDecimal)currentCashAmount, (String)currency));
                dialog.setBody((Node)panel).setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.fiscalToolCashIncome).addButton(DialogButtonStyle.DECLINE, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                    BigDecimal incomeCashAmount = (BigDecimal)panel.getIncomeCashAmountNode().getValue();
                    Notifications.get().submitTask(() -> {
                        FiscalReceiptHelper.cashIncome(incomeCashAmount.doubleValue());
                        this.update(fiscalToolPanel);
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.cashIncomeCompleted, (Object[])new Object[0])});
                    }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.cashIncomeProcessing);
                }, (BooleanExpression)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{panel.getIncomeCashAmountNode().valueProperty()});
                    }

                    protected boolean computeValue() {
                        return panel.getIncomeCashAmountNode().getValue() != null && ((BigDecimal)panel.getIncomeCashAmountNode().getValue()).compareTo(BigDecimal.ZERO) > 0;
                    }
                }).showGlobal();
            });
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.cashIncomeProcessing);
    }

    private void cashOutcome(FiscalToolPanel fiscalToolPanel) {
        Notifications.get().submitTask(() -> {
            String currency = Prefetched.getData().getEquivalentCurrency();
            final BigDecimal currentCashAmount = Optional.ofNullable(FiscalReceiptHelper.getCashBoxAmount()).map(item -> BigDecimal.valueOf(item)).orElse(null);
            FxUtil.waitForFxThread(() -> {
                Dialog dialog = new Dialog();
                final CashOutcomePanel panel = new CashOutcomePanel(false);
                panel.getCurrentCashAmountNode().setValue(SystemHelper.getMoney((BigDecimal)currentCashAmount, (String)currency));
                dialog.setBody((Node)panel).setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.fiscalToolCashOutcome).addButton(DialogButtonStyle.DECLINE, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                    BigDecimal outcomeCashAmount = (BigDecimal)panel.getOutcomeCashAmountNode().getValue();
                    Notifications.get().submitTask(() -> {
                        FiscalReceiptHelper.cashOutcome(outcomeCashAmount.doubleValue());
                        this.update(fiscalToolPanel);
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.cashOutcomeCompleted, (Object[])new Object[0])});
                    }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.cashOutcomeProcessing);
                }, (BooleanExpression)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{panel.getOutcomeCashAmountNode().valueProperty()});
                    }

                    protected boolean computeValue() {
                        return panel.getOutcomeCashAmountNode().getValue() != null && ((BigDecimal)panel.getOutcomeCashAmountNode().getValue()).compareTo(BigDecimal.ZERO) > 0 && ((BigDecimal)panel.getOutcomeCashAmountNode().getValue()).compareTo(currentCashAmount) <= 0;
                    }
                }).showGlobal();
            });
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.cashOutcomeProcessing);
    }

    private void update(FiscalToolPanel fiscalToolPanel) throws Exception {
        String currency = Prefetched.getData().getEquivalentCurrency();
        boolean sessionOpen = FiscalReceiptHelper.isSessionOpen();
        boolean sessionExpired = FiscalReceiptHelper.isSessionExpired();
        BigDecimal cashAmount = sessionOpen ? (BigDecimal)Optional.ofNullable(FiscalReceiptHelper.getCashBoxAmount()).map(item -> BigDecimal.valueOf(item)).orElse(null) : null;
        FxUtil.waitForFxThread(() -> {
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getOpenSessionNode().setDisable(sessionOpen || sessionExpired);
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getXReportNode().setDisable(!sessionOpen || sessionExpired);
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getZReportNode().setDisable(!sessionOpen && !sessionExpired);
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getSessionReportNode().setDisable(!sessionOpen);
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getCheckOfdConnectionNode().setDisable(!sessionOpen || sessionExpired);
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getCashIncomeNode().setDisable(!sessionOpen || sessionExpired);
            ((FiscalToolActionPanel)fiscalToolPanel.getActionCard().getContent()).getCashOutcomeNode().setDisable(!sessionOpen || sessionExpired || cashAmount == null || cashAmount.compareTo(BigDecimal.ZERO) <= 0);
            ((FiscalToolMainPanel)fiscalToolPanel.getMainCard().getContent()).getCashAmountNode().setValue(SystemHelper.getMoney((BigDecimal)cashAmount, (String)currency));
        });
    }
}

