/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.system.ServerFileVM;
import com.gridnine.xtrip.client.fx.model.system.ServerLogsPaneController;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.ServerLogsService;
import com.gridnine.xtrip.common.model.system.fs.ServerFile;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.TableColumn;
import javafx.stage.FileChooser;
import javafx.util.Pair;

class ServerLogsDialog {
    private final List<String> nodes;
    final ServerLogsPaneController controller;
    String selectedNodeId;
    ServerFileVM root;
    String selectedFolderUid;

    ServerLogsDialog(List<String> ids) {
        this.nodes = new ArrayList<String>(ids);
        this.controller = new ServerLogsPaneController(false);
        this.controller.getView().getNodeIdNode().setItemsSupplier(() -> this.nodes);
        this.selectedNodeId = this.nodes.get(0);
        if (this.nodes.size() == 1) {
            this.controller.getView().getNodeIdCell().setHidden(true);
        } else {
            this.controller.getView().getNodeIdNode().setValue((Object)this.selectedNodeId);
            this.controller.getView().getNodeIdNode().valueProperty().addListener((src, o, n) -> {
                this.selectedNodeId = n;
                this.root = null;
                this.controller.getView().getFileSystemNode().reloadData();
            });
        }
        this.controller.getView().getSearchNode().setPromptText(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Search);
        ((TextFieldWidget)this.controller.getView().getSearchCell().getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> this.controller.getView().getFileSystemNode().reloadData());
        this.controller.getView().getFileSystemNode().setHandler((DataViewHandler)new DataViewHandler<ServerFileVM>(){

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                if (ServerLogsDialog.this.root == null) {
                    this.getData().clear();
                    Notifications.get().submitTask(() -> {
                        ServerLogsDialog.this.root = this.toVM(((ServerLogsService)RpcServiceManager.get().getService(ServerLogsService.class)).getFileForNode(ServiceInvocationContext.get(), ServerLogsDialog.this.selectedNodeId), null);
                        ServerLogsDialog.this.selectedFolderUid = ServerLogsDialog.this.root.getUid();
                        FxUtil.submitToFxThread(() -> this.getData().setAll(this.populate(sorting, this.toLowerCase(ServerLogsDialog.this.controller.getView().getSearchNode().getValue()))));
                    }, this.getMutex());
                } else {
                    this.getData().setAll(this.populate(sorting, this.toLowerCase(ServerLogsDialog.this.controller.getView().getSearchNode().getValue())));
                }
            }

            private ServerFileVM toVM(ServerFile model, ServerFileVM parent) {
                ServerFileVM result = new ServerFileVM();
                result.setUid(model.getUid());
                if (parent != null) {
                    result.setParentUid(parent.getUid());
                    result.setPath(parent.getPath() + model.getFileName() + '/');
                } else {
                    result.setPath("/logs/");
                }
                result.setDirectory(model.isDirectory());
                result.setType(model.isDirectory() ? com.gridnine.xtrip.client.fx.standard.l10n.Messages.Folder : com.gridnine.xtrip.client.fx.standard.l10n.Messages.File);
                result.setName(model.getFileName());
                result.setAbsolutePath(model.getAbsolutePath());
                if (!model.isDirectory()) {
                    result.setSizeInBytes(Long.valueOf(model.getSizeInBytes()));
                    result.setSize(this.prettySize(model.getSizeInBytes()));
                    result.setModified(MiscUtil.toDate((LocalDateTime)model.getModified()));
                    result.setTimestamp((String)StandardRenderers.DATE_TIME.apply((Object)model.getModified()));
                    result.setSave(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Dialog_save);
                }
                for (ServerFile child : model.getChildren()) {
                    result.getChildren().add(this.toVM(child, result));
                }
                return result;
            }

            private String prettySize(long value) {
                if (value < 1024L) {
                    return String.valueOf(value) + " B";
                }
                if (value < 0x100000L) {
                    return String.valueOf(value / 1024L) + " KB";
                }
                if (value < 0x40000000L) {
                    return String.valueOf(value / 1024L / 1024L) + " MB";
                }
                return String.valueOf(value / 1024L / 1024L / 1024L) + " GB";
            }

            private List<ServerFileVM> populate(List<Pair<String, SortOrder>> sorting, String searchText) {
                ServerFileVM file = this.findFile(ServerLogsDialog.this.root, ServerLogsDialog.this.selectedFolderUid);
                ArrayList<ServerFileVM> result = new ArrayList<ServerFileVM>();
                if (file != null && file.isDirectory()) {
                    ServerLogsDialog.this.controller.getView().getPathNode().setText(file.getPath());
                    if (file.getParentUid() != null) {
                        ServerFileVM vm = new ServerFileVM();
                        vm.setUid(file.getParentUid());
                        vm.setName("..");
                        vm.setDirectory(true);
                        vm.setType(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Folder);
                        result.add(vm);
                    }
                    Comparator comparator = null;
                    if (sorting.isEmpty()) {
                        comparator = ServerLogsDialog.this.createComparator("type", SortOrder.ASC).thenComparing(ServerLogsDialog.this.createComparator("timestamp", SortOrder.DESC));
                    } else {
                        for (Pair<String, SortOrder> sortOrderPair : sorting) {
                            Comparator currentComparator = ServerLogsDialog.this.createComparator((String)sortOrderPair.getKey(), (SortOrder)sortOrderPair.getValue());
                            if (comparator == null) {
                                comparator = currentComparator;
                                continue;
                            }
                            comparator = comparator.thenComparing(currentComparator);
                        }
                    }
                    result.addAll(file.getChildren().stream().filter(t -> this.isAppropriate((ServerFileVM)t, searchText)).sorted(comparator).collect(Collectors.toList()));
                }
                return result;
            }

            private boolean isAppropriate(ServerFileVM file, String searchText) {
                if ("..".equals(file.getName()) || TextUtil.isBlank((String)searchText)) {
                    return true;
                }
                if (file.getName() != null && file.getName().toLowerCase().contains(searchText)) {
                    return true;
                }
                if (!file.isDirectory()) {
                    return false;
                }
                for (ServerFileVM child : file.getChildren()) {
                    if (!this.isAppropriate(child, searchText)) continue;
                    return true;
                }
                return false;
            }

            private ServerFileVM findFile(ServerFileVM file, String uid) {
                if (uid.equals(file.getUid())) {
                    return file;
                }
                for (ServerFileVM child : file.getChildren()) {
                    ServerFileVM result = this.findFile(child, uid);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }

            private String toLowerCase(String str) {
                return str == null ? null : str.trim().toLowerCase();
            }

            protected int getOffset() {
                return 0;
            }

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }
        });
        this.controller.getView().getFileSystemNode().getTableView().setActionHandler((TableActionHandler)new TableActionHandler<ServerFileVM>(){

            public void onAction(TableColumn<ServerFileVM, ?> column, ServerFileVM item) {
                if ("name".equals(column.getId())) {
                    if (item.isDirectory()) {
                        ServerLogsDialog.this.selectedFolderUid = item.getUid();
                        ServerLogsDialog.this.controller.getView().getFileSystemNode().reloadData();
                    } else {
                        Notifications.get().submitTask(() -> {
                            File file = File.createTempFile("xtrip-log-", ".log");
                            try (FileOutputStream outputStream = new FileOutputStream(file.toPath().toString(), true);){
                                ServerLogsDialog.this.saveFile(item, outputStream);
                            }
                            FxUtil.openFile((File)file);
                        }, Messages.General_Data_loading);
                    }
                }
                if ("save".equals(column.getId())) {
                    FileChooser fc = new FileChooser();
                    fc.setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Saving);
                    ClientSettings clientSettings = ClientSettings.get();
                    File file = clientSettings.getFileChooserDirectory();
                    if (UiUtil.isFileValid((File)file) && file.isDirectory()) {
                        fc.setInitialDirectory(file);
                    } else {
                        fc.setInitialDirectory(Environment.getDataFolder());
                    }
                    fc.setInitialFileName(item.getName());
                    file = fc.showSaveDialog(ServerLogsDialog.this.controller.getView().getScene().getWindow());
                    if (file == null) {
                        return;
                    }
                    clientSettings.setFileChooserDirectory(file.getParentFile());
                    clientSettings.save();
                    Notifications.get().submitTask(() -> {
                        try (FileOutputStream outputStream = new FileOutputStream(file.toPath().toString(), true);){
                            ServerLogsDialog.this.saveFile(item, outputStream);
                        }
                        Notifications.get().showFlashNotification(com.gridnine.xtrip.client.fx.standard.l10n.Messages.getData_saved_to_file(file), null);
                    }, Messages.General_Data_loading);
                }
            }

            public boolean isActive(TableColumn<ServerFileVM, ?> column, ServerFileVM item) {
                return "name".equals(column.getId()) || item != null && !item.isDirectory() && "save".equals(column.getId());
            }
        });
        this.controller.getView().setPrefWidth(900.0);
        this.controller.getView().getFileSystemNode().getTableView().findColumn("name").setMinWidth(300.0);
    }

    private Comparator<ServerFileVM> createComparator(String columnName, SortOrder sortOrder) {
        Comparator<ServerFileVM> foldersFirstComparator = Comparator.comparing(ServerFileVM::isDirectory).reversed();
        Comparator thisComparator = null;
        switch (columnName) {
            case "type": {
                if (sortOrder != SortOrder.DESC) break;
                foldersFirstComparator = foldersFirstComparator.reversed();
                break;
            }
            case "name": {
                thisComparator = (first, second) -> TextUtil.compare((String)first.getName(), (String)second.getName(), (boolean)true, (boolean)false);
                break;
            }
            case "size": {
                thisComparator = (first, second) -> MiscUtil.compare((Comparable)first.getSizeInBytes(), (Comparable)second.getSizeInBytes(), (boolean)true);
                break;
            }
            case "timestamp": {
                thisComparator = (first, second) -> MiscUtil.compare((Date)first.getModified(), (Date)second.getModified(), (boolean)true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported column name: " + columnName);
            }
        }
        if (thisComparator != null) {
            if (sortOrder == SortOrder.DESC) {
                thisComparator = thisComparator.reversed();
            }
            return foldersFirstComparator.thenComparing(thisComparator);
        }
        return foldersFirstComparator;
    }

    private void saveFile(ServerFileVM item, FileOutputStream outputStream) throws Exception {
        long offset = 0L;
        while (true) {
            MiscUtil.Pair content;
            if ((content = ((ServerLogsService)RpcServiceManager.get().getService(ServerLogsService.class)).getContent(ServiceInvocationContext.get(), this.selectedNodeId, item.getAbsolutePath(), offset)) == null) {
                continue;
            }
            if (content.getSecond() == null) break;
            outputStream.write((byte[])content.getSecond());
            offset = (Long)content.getFirst();
        }
    }
}

