/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.support.BaseBugReport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ExportedItem;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseBugReportDialog<E extends BaseBugReport, P extends BaseBugReportPanel> {
    private void collectSettings(List<ItemExportSettings> allSettings, ItemExportSettings item, List<String> selectedIds) {
        if (item.isGroup()) {
            for (ItemExportSettings nestedItem : item.getChildren()) {
                this.collectSettings(allSettings, nestedItem, selectedIds);
            }
            return;
        }
        if (!selectedIds.contains(item.getObjectId())) {
            return;
        }
        ItemExportSettings settings = new ItemExportSettings();
        settings.setItemType(item.getItemType());
        settings.setObjectId(item.getObjectId());
        settings.setExportType(item.getExportType());
        switch (item.getExportType()) {
            case QUERY: {
                settings.setQueryData(item.getQueryData());
                break;
            }
            case SELECTED: {
                settings.getSelectedItems().addAll(item.getSelectedItems());
                break;
            }
            default: {
                settings.setExportType(ExportType.ALL);
            }
        }
        allSettings.add(settings);
    }

    public void showDialog() {
        Dialog dialog = new Dialog();
        P panel = this.createPanel();
        dialog.setTitle(this.getDialogTitle()).setAutoClose(false).setExpandToParent(true).setBody(panel).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Form, () -> {
            String validationError = this.validate(panel);
            if (validationError != null) {
                dialog.setValidationMessages(true, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)validationError, (Object[])new Object[0])});
                return;
            }
            ArrayList<ItemExportSettings> exportSettingsList = new ArrayList<ItemExportSettings>();
            exportSettingsList.addAll(this.getExportSettings(panel));
            this.updateSettings(exportSettingsList, panel, this::doExport);
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).showGlobal();
    }

    protected String validate(P panel) {
        if (((BaseBugReportPanel)((Object)panel)).getFile() == null) {
            return Messages.No_file_specified;
        }
        if (((BaseBugReportPanel)((Object)panel)).getSelectedTreeItems().isEmpty()) {
            return Messages.No_paged_object_selected;
        }
        if (TextUtil.isBlank((String)((BaseBugReportPanel)((Object)panel)).getTitle())) {
            return Messages.Missing_title;
        }
        if (((BaseBugReportPanel)((Object)panel)).getAgency() == null) {
            return Messages.Not_Specified_Agency;
        }
        return null;
    }

    protected ArrayList<ItemExportSettings> getExportSettings(P panel) {
        ArrayList<ItemExportSettings> exportSettingsList = new ArrayList<ItemExportSettings>();
        this.collectSettings(exportSettingsList, ((BaseBugReportPanel)((Object)panel)).getTreeRoot(), ((BaseBugReportPanel)((Object)panel)).getSelectedTreeItems());
        return exportSettingsList;
    }

    protected void doExport(ArrayList<ItemExportSettings> exportSettings, P panel) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler((BaseBugReportPanel)((Object)panel), exportSettings){
            final /* synthetic */ BaseBugReportPanel val$panel;
            final /* synthetic */ ArrayList val$exportSettings;
            {
                this.val$panel = baseBugReportPanel;
                this.val$exportSettings = arrayList;
            }

            protected String getTitle() {
                return BaseBugReportDialog.this.getTaskTitle();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onCompleted(Object res, List<Message> log) {
                Object supportObject = BaseBugReportDialog.this.createSupportObject(this.val$panel);
                Map result = (Map)res;
                List exportedItems = result.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                supportObject.getExportedItems().addAll(exportedItems);
                BaseBugReportDialog.this.setCustomFields(this.val$panel, supportObject, result);
                EntityContainer bugReportContainer = EntityContainer.create(supportObject);
                bugReportContainer.setCreated(new Date());
                bugReportContainer.setCreatedBy(ServiceInvocationContext.get().getUser());
                bugReportContainer.getVersionInfo().setDataSource("fx-bug-report");
                this.val$panel.getFile().getParentFile().mkdirs();
                try (FileOutputStream outputStream = new FileOutputStream(this.val$panel.getFile());
                     ZipOutputStream strm = new ZipOutputStream(outputStream);){
                    Document doc = DocumentBuilderHelper.newDocument();
                    doc.appendChild(doc.createElement("objects"));
                    Element rootElm = doc.getDocumentElement();
                    rootElm.setAttribute("totalCount", Integer.toString(1));
                    XHelper.writeObject((Element)rootElm, (String)"object", (Object)bugReportContainer);
                    String entryfileName = String.format("%s%08d.xml", bugReportContainer.getClass().getName(), 1);
                    strm.putNextEntry(new ZipEntry(entryfileName));
                    XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm));
                    strm.closeEntry();
                    strm.flush();
                }
                catch (Exception exception) {
                    log.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Save_err, (Throwable)exception, (Object[])new Object[0]));
                    ErrorHandler.handle((Throwable)exception);
                }
                finally {
                    log.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Export_complited, (Object[])new Object[0]));
                }
            }

            protected Serializable getTaskParameters() {
                return this.val$exportSettings;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.BugReportExportAsyncTask";
            }
        });
    }

    protected void setGeneralFields(P panel, E obj) {
        obj.setTitle(((BaseBugReportPanel)((Object)panel)).getTitle());
        obj.setAgency(((BaseBugReportPanel)((Object)panel)).getAgency());
        obj.setCreateDate(new Date());
        obj.setDescription(((BaseBugReportPanel)((Object)panel)).getDescription());
        obj.setExportSettings(((BaseBugReportPanel)((Object)panel)).getTreeRoot());
    }

    protected abstract P createPanel();

    protected abstract void updateSettings(ArrayList<ItemExportSettings> var1, P var2, BiConsumer<ArrayList<ItemExportSettings>, P> var3);

    protected abstract String getDialogTitle();

    protected abstract String getTaskTitle();

    protected abstract E createSupportObject(P var1);

    protected abstract void setCustomFields(P var1, E var2, Map<ItemExportSettings, List<ExportedItem>> var3);
}

